/*
 * Decompiled with CFR 0.152.
 */
package org.apache.netbeans.nbpackage;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.netbeans.nbpackage.Option;
import org.apache.netbeans.nbpackage.StringUtils;

public final class Configuration {
    private final Map<String, String> properties;
    private final boolean verbose;
    private final Consumer<String> infoHandler;
    private final Consumer<String> warningHandler;

    private Configuration(Builder builder) {
        this.properties = Map.copyOf(builder.properties);
        this.verbose = builder.verbose;
        this.infoHandler = builder.infoHandler;
        this.warningHandler = builder.warningHandler;
    }

    public String getValue(Option<?> option) {
        return this.properties.getOrDefault(option.key(), option.defaultValue());
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public Consumer<String> infoHandler() {
        return this.infoHandler;
    }

    public Consumer<String> warningHandler() {
        return this.warningHandler;
    }

    Map<String, String> properties() {
        return this.properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, String> properties = new HashMap<String, String>();
        private boolean verbose;
        private Consumer<String> infoHandler;
        private Consumer<String> warningHandler = s -> System.out.println((String)s);

        private Builder() {
            this.infoHandler = this.warningHandler;
        }

        public Builder load(Path path) throws IOException {
            Properties extraProps = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(path);){
                extraProps.load(reader);
            }
            Map<String, String> configReplace = Map.of("CONFIG", path.getParent().toString());
            extraProps.entrySet().forEach(e -> this.properties.put(e.getKey().toString(), StringUtils.replaceTokens(e.getValue().toString(), configReplace)));
            return this;
        }

        public Builder set(Option<?> option, String value) {
            this.properties.put(option.key(), value);
            return this;
        }

        public Builder verbose() {
            this.verbose = true;
            return this;
        }

        public Builder messageHandlers(Consumer<String> warning, Consumer<String> info) {
            Objects.requireNonNull(warning);
            Objects.requireNonNull(info);
            this.warningHandler = warning;
            this.infoHandler = info;
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }
    }
}

