/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.masterfs.filebasedfs.fileobjects;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.masterfs.filebasedfs.FileBasedFileSystem;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.FileObjectFactory;
import org.netbeans.modules.masterfs.filebasedfs.fileobjects.RefreshSlow;
import org.netbeans.modules.masterfs.filebasedfs.utils.FSException;
import org.netbeans.modules.masterfs.filebasedfs.utils.FileInfo;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class RootObj<T extends FileObject>
extends FileObject {
    private T realRoot = null;

    public RootObj(T realRoot) {
        this.realRoot = realRoot;
    }

    @Override
    public final String getName() {
        return ((FileObject)this.getRealRoot()).getName();
    }

    @Override
    public final String getExt() {
        return ((FileObject)this.getRealRoot()).getExt();
    }

    @Override
    public final FileSystem getFileSystem() throws FileStateInvalidException {
        return ((FileObject)this.getRealRoot()).getFileSystem();
    }

    @Override
    public final FileObject getParent() {
        return null;
    }

    @Override
    public final boolean isFolder() {
        return true;
    }

    @Override
    public final boolean isData() {
        return !this.isFolder();
    }

    @Override
    public final Date lastModified() {
        return new Date(0L);
    }

    @Override
    public final boolean isRoot() {
        return true;
    }

    @Override
    public final boolean isValid() {
        return true;
    }

    @Override
    public final void rename(FileLock lock, String name, String ext) throws IOException {
        FSException.io("EXC_CannotRenameRoot", this.getFileSystem().getDisplayName());
    }

    @Override
    public final void delete(FileLock lock) throws IOException {
        FSException.io("EXC_CannotDeleteRoot", this.getFileSystem().getDisplayName());
    }

    @Override
    public final Object getAttribute(String attrName) {
        if (attrName.equals("SupportsRefreshForNoPublicAPI")) {
            return true;
        }
        if (attrName.equals("refreshSlow")) {
            return new RefreshSlow();
        }
        return ((FileObject)this.getRealRoot()).getAttribute(attrName);
    }

    @Override
    public final void setAttribute(String attrName, Object value) throws IOException {
        if ("request_for_refreshing_files_be_aware_this_is_not_public_api".equals(attrName) && value instanceof File[]) {
            RootObj.invokeRefreshFor(null, (File[])value);
            return;
        }
        ((FileObject)this.getRealRoot()).setAttribute(attrName, value);
    }

    static void invokeRefreshFor(RefreshSlow slow, File[] files) {
        RootObj.invokeRefreshFor(slow, files, false);
    }

    static void invokeRefreshFor(RefreshSlow slow, File[] files, boolean ignoreRecursiveListeners) {
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            files[i] = FileUtil.normalizeFile(file);
        }
        HashMap files2Factory = new HashMap();
        Map<File, ? extends FileObjectFactory> roots2Factory = FileBasedFileSystem.factories();
        Arrays.sort(files);
        for (File file : files) {
            Object factory = roots2Factory.get(file);
            if (factory == null) {
                factory = roots2Factory.get(new FileInfo(file).getRoot().getFile());
            }
            if (factory == null) continue;
            ArrayList<File> lf = (ArrayList<File>)files2Factory.get(factory);
            if (lf == null) {
                lf = new ArrayList<File>();
                files2Factory.put((FileObjectFactory)factory, lf);
            } else {
                File tmp = file;
                while (tmp.getParentFile() != null) {
                    if (lf.contains(tmp)) {
                        tmp = null;
                        break;
                    }
                    tmp = tmp.getParentFile();
                }
                if (tmp == null) continue;
            }
            lf.add(file);
        }
        if (slow != null) {
            int cnt = 0;
            for (Map.Entry entry : files2Factory.entrySet()) {
                FileObjectFactory factory = (FileObjectFactory)entry.getKey();
                cnt += factory.getSize();
            }
            slow.estimate(cnt);
        }
        for (Map.Entry entry : files2Factory.entrySet()) {
            FileObjectFactory factory = (FileObjectFactory)entry.getKey();
            List lf = (List)entry.getValue();
            if (lf.size() == 1) {
                for (File file : lf) {
                    if (file.getParentFile() == null) {
                        factory.refresh(slow, ignoreRecursiveListeners, true);
                        continue;
                    }
                    factory.refreshFor(slow, ignoreRecursiveListeners, file);
                }
                continue;
            }
            if (lf.size() <= 1) continue;
            Object[] arr = lf.toArray(new File[0]);
            Arrays.sort(arr);
            factory.refreshFor(slow, ignoreRecursiveListeners, (File[])arr);
        }
    }

    @Override
    public final Enumeration<String> getAttributes() {
        return ((FileObject)this.getRealRoot()).getAttributes();
    }

    @Override
    public final void addFileChangeListener(FileChangeListener fcl) {
        ((FileObject)this.getRealRoot()).addFileChangeListener(fcl);
    }

    @Override
    public final void removeFileChangeListener(FileChangeListener fcl) {
        ((FileObject)this.getRealRoot()).removeFileChangeListener(fcl);
    }

    @Override
    public final long getSize() {
        return 0L;
    }

    @Override
    public final InputStream getInputStream() throws FileNotFoundException {
        return ((FileObject)this.getRealRoot()).getInputStream();
    }

    @Override
    public final OutputStream getOutputStream(FileLock lock) throws IOException {
        return ((FileObject)this.getRealRoot()).getOutputStream(lock);
    }

    @Override
    public final FileLock lock() throws IOException {
        return ((FileObject)this.getRealRoot()).lock();
    }

    @Override
    @Deprecated
    public final void setImportant(boolean b) {
        ((FileObject)this.getRealRoot()).setImportant(b);
    }

    @Override
    public final FileObject[] getChildren() {
        return ((FileObject)this.getRealRoot()).getChildren();
    }

    @Override
    public final FileObject getFileObject(String name, String ext) {
        return ((FileObject)this.getRealRoot()).getFileObject(name, ext);
    }

    @Override
    public final FileObject getFileObject(String relativePath) {
        return ((FileObject)this.getRealRoot()).getFileObject(relativePath);
    }

    @Override
    public final FileObject createFolder(String name) throws IOException {
        return ((FileObject)this.getRealRoot()).createFolder(name);
    }

    @Override
    public final FileObject createData(String name, String ext) throws IOException {
        return ((FileObject)this.getRealRoot()).createData(name, ext);
    }

    @Override
    @Deprecated
    public final boolean isReadOnly() {
        return ((FileObject)this.getRealRoot()).isReadOnly();
    }

    public final T getRealRoot() {
        return this.realRoot;
    }

    @Override
    public String getPath() {
        return "";
    }

    @Override
    public String toString() {
        return ((FileObject)this.getRealRoot()).toString();
    }
}

