/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.indexing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import jpt.sun.tools.javac.code.Symbol;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ModuleElement;
import jpt30.lang.model.element.Name;
import jpt30.lang.model.element.PackageElement;
import jpt30.lang.model.element.RecordComponentElement;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.element.VariableElement;
import jpt30.lang.model.util.ElementScanner9;
import jpt30.tools.JavaFileObject;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.openide.util.Exceptions;

public final class FQN2Files {
    private static final Logger LOG = Logger.getLogger(FQN2Files.class.getName());
    private static final String FQN2FILES_FILE = "fqn2files.properties";
    private final File propFile;
    private final Properties props = new Properties();

    public static FQN2Files forRoot(URL root) throws IOException {
        return new FQN2Files(root);
    }

    private FQN2Files(URL root) throws IOException {
        this.propFile = new File(JavaIndex.getIndex(root), FQN2FILES_FILE);
        this.propFile.createNewFile();
        this.load();
    }

    public void set(Iterable<? extends Element> topLevelElements, final URL file) {
        new ElementScanner9(){

            @Override
            public Object visitType(TypeElement e, Object p) {
                String fqn = e instanceof Symbol.TypeSymbol ? ((Symbol.TypeSymbol)((Object)e)).flatName().toString() : e.getQualifiedName().toString();
                String value = FQN2Files.this.props.getProperty(fqn);
                if (value == null) {
                    FQN2Files.this.props.setProperty(fqn, file.toExternalForm());
                }
                return this.scan(e.getEnclosedElements(), p);
            }

            @Override
            public Object visitModule(ModuleElement e, Object p) {
                String fqn;
                String value;
                if (e instanceof Symbol.ModuleSymbol && (value = FQN2Files.this.props.getProperty(fqn = ((Symbol.ModuleSymbol)e).module_info.flatName().toString())) == null) {
                    FQN2Files.this.props.setProperty(fqn, file.toExternalForm());
                }
                return null;
            }

            @Override
            public Object visitPackage(PackageElement e, Object p) {
                String fqn;
                String value;
                if (e instanceof Symbol.PackageSymbol && (value = FQN2Files.this.props.getProperty(fqn = ((Symbol.PackageSymbol)e).package_info.flatName().toString())) == null) {
                    FQN2Files.this.props.setProperty(fqn, file.toExternalForm());
                }
                return null;
            }

            @Override
            public Object visitRecordComponent(RecordComponentElement e, Object p) {
                return this.visitVariable((VariableElement)((Object)e), p);
            }

            @Override
            public Object scan(Element e, Object p) {
                return super.scan(e, p);
            }
        }.scan(topLevelElements, null);
    }

    public boolean remove(String fqn, URL file) {
        String value = this.props.getProperty(fqn);
        if (value != null && value.equals(file.toExternalForm())) {
            this.props.remove(fqn);
            return true;
        }
        return false;
    }

    public void store() throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.propFile));){
            this.props.store(out, "");
        }
    }

    private void load() throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.propFile), 65536);){
            this.props.load(in);
        }
    }

    public boolean check(Name fqn, JavaFileObject jfo) {
        String value = this.props.getProperty(fqn.toString());
        try {
            return value != null && !value.equals(jfo.toUri().toURL().toExternalForm());
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace(ex);
            return false;
        }
    }

    public boolean check(String fqn, URL url) {
        String value = this.props.getProperty(fqn);
        return value != null && !value.equals(url.toExternalForm());
    }
}

