/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.common;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.mvndaemon.mvnd.common.DaemonInfo;

public class DaemonCompatibilitySpec {
    private final Path javaHome;
    private final List<String> options;

    public DaemonCompatibilitySpec(Path javaHome, List<String> options) {
        this.javaHome = Objects.requireNonNull(javaHome, "javaHome");
        this.options = Objects.requireNonNull(options, "options");
    }

    public Path getJavaHome() {
        return this.javaHome;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public Result isSatisfiedBy(DaemonInfo daemon) {
        if (!this.javaHomeMatches(daemon)) {
            return new Result(false, () -> "Java home is different.\n" + this.diff(daemon));
        }
        if (!this.daemonOptsMatch(daemon)) {
            return new Result(false, () -> "At least one daemon option is different.\n" + this.diff(daemon));
        }
        return new Result(true, () -> {
            throw new RuntimeException("No reason if DaemonCompatibilityResult.compatible == true");
        });
    }

    private String diff(DaemonInfo context) {
        StringBuilder sb = new StringBuilder("Wanted: ");
        this.appendFields(sb);
        sb.append("\nActual: ");
        context.appendNonKeyFields(sb).append("id=").append(context.getId()).append('\n');
        return sb.toString();
    }

    private boolean daemonOptsMatch(DaemonInfo daemon) {
        return daemon.getOptions().containsAll(this.options) && daemon.getOptions().size() == this.options.size();
    }

    private boolean javaHomeMatches(DaemonInfo daemon) {
        return this.javaHome.equals(Paths.get(daemon.getJavaHome(), new String[0]));
    }

    StringBuilder appendFields(StringBuilder sb) {
        return sb.append("javaHome=").append(this.javaHome).append(", options=").append(this.options);
    }

    public String toString() {
        return this.appendFields(new StringBuilder("DaemonCompatibilitySpec{")).append('}').toString();
    }

    public static class Result {
        private final boolean compatible;
        private final Supplier<String> why;

        Result(boolean compatible, Supplier<String> why) {
            this.compatible = compatible;
            this.why = why;
        }

        public boolean isCompatible() {
            return this.compatible;
        }

        public String getWhy() {
            return this.why.get();
        }
    }
}

