/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.collector;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.building.ModelProblemUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.collector.ProjectsSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultProjectsSelector
implements ProjectsSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectsSelector.class);
    private final ProjectBuilder projectBuilder;

    @Inject
    public DefaultProjectsSelector(ProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    @Override
    public List<MavenProject> selectProjects(List<File> files, MavenExecutionRequest request) throws ProjectBuildingException {
        ProjectBuildingRequest projectBuildingRequest = request.getProjectBuildingRequest();
        boolean hasProjectSelection = !request.getProjectActivation().isEmpty();
        boolean isRecursive = hasProjectSelection || request.isRecursive();
        List<ProjectBuildingResult> results = this.projectBuilder.build(files, isRecursive, projectBuildingRequest);
        ArrayList<MavenProject> projects = new ArrayList<MavenProject>(results.size());
        long totalProblemsCount = 0L;
        for (ProjectBuildingResult result : results) {
            projects.add(result.getProject());
            int problemsCount = result.getProblems().size();
            totalProblemsCount += (long)problemsCount;
            if (problemsCount == 0 || !LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("");
            LOGGER.warn("{} {} encountered while building the effective model for '{}' (use -e to see details)", new Object[]{problemsCount, problemsCount == 1 ? "problem was" : "problems were", result.getProject().getId()});
            if (!request.isShowErrors()) continue;
            for (ModelProblem problem : result.getProblems()) {
                String loc = ModelProblemUtils.formatLocation((ModelProblem)problem, (String)result.getProjectId());
                LOGGER.warn("{}{}", (Object)problem.getMessage(), loc != null && !loc.isEmpty() ? " @ " + loc : "");
            }
        }
        if (totalProblemsCount > 0L) {
            LOGGER.warn("");
            LOGGER.warn("Total model problems reported: {}", (Object)totalProblemsCount);
            LOGGER.warn("");
            LOGGER.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
            LOGGER.warn("");
            LOGGER.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
            LOGGER.warn("");
        }
        return projects;
    }
}

