/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Resolution
implements Serializable {
    final String field;
    final String pathScope;
    final String requestType;

    protected Resolution(Builder builder) {
        String string = builder.field != null ? builder.field : (this.field = builder.base != null ? builder.base.field : null);
        String string2 = builder.pathScope != null ? builder.pathScope : (this.pathScope = builder.base != null ? builder.base.pathScope : null);
        this.requestType = builder.requestType != null ? builder.requestType : (builder.base != null ? builder.base.requestType : null);
    }

    public String getField() {
        return this.field;
    }

    public String getPathScope() {
        return this.pathScope;
    }

    public String getRequestType() {
        return this.requestType;
    }

    @Nonnull
    public Builder with() {
        return Resolution.newBuilder(this);
    }

    @Nonnull
    public Resolution withField(String field) {
        return Resolution.newBuilder(this, true).field(field).build();
    }

    @Nonnull
    public Resolution withPathScope(String pathScope) {
        return Resolution.newBuilder(this, true).pathScope(pathScope).build();
    }

    @Nonnull
    public Resolution withRequestType(String requestType) {
        return Resolution.newBuilder(this, true).requestType(requestType).build();
    }

    @Nonnull
    public static Resolution newInstance() {
        return Resolution.newInstance(true);
    }

    @Nonnull
    public static Resolution newInstance(boolean withDefaults) {
        return Resolution.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Resolution.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Resolution from) {
        return Resolution.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Resolution from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        Resolution base;
        String field;
        String pathScope;
        String requestType;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Resolution base, boolean forceCopy) {
            if (forceCopy) {
                this.field = base.field;
                this.pathScope = base.pathScope;
                this.requestType = base.requestType;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder field(String field) {
            this.field = field;
            return this;
        }

        @Nonnull
        public Builder pathScope(String pathScope) {
            this.pathScope = pathScope;
            return this;
        }

        @Nonnull
        public Builder requestType(String requestType) {
            this.requestType = requestType;
            return this;
        }

        @Nonnull
        public Resolution build() {
            if (!(this.base == null || this.field != null && this.field != this.base.field || this.pathScope != null && this.pathScope != this.base.pathScope || this.requestType != null && this.requestType != this.base.requestType)) {
                return this.base;
            }
            return new Resolution(this);
        }
    }
}

