/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.services;

import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.api.annotations.Consumer;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Nonnull;

@Experimental
@Consumer
public interface Transport
extends Closeable {
    public boolean get(@Nonnull URI var1, @Nonnull Path var2);

    @Nonnull
    public Optional<byte[]> getBytes(@Nonnull URI var1);

    @Nonnull
    public Optional<String> getString(@Nonnull URI var1, @Nonnull Charset var2);

    @Nonnull
    default public Optional<String> getString(@Nonnull URI relativeSource) {
        return this.getString(relativeSource, StandardCharsets.UTF_8);
    }

    public void put(@Nonnull Path var1, @Nonnull URI var2);

    public void putBytes(@Nonnull byte[] var1, @Nonnull URI var2);

    public void putString(@Nonnull String var1, @Nonnull Charset var2, @Nonnull URI var3);

    default public void putString(@Nonnull String source, @Nonnull URI relativeTarget) {
        this.putString(source, StandardCharsets.UTF_8, relativeTarget);
    }
}

