/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.app.desktop.components.dialog.menubar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import org.apache.lucene.luke.app.IndexHandler;
import org.apache.lucene.luke.app.desktop.Preferences;
import org.apache.lucene.luke.app.desktop.PreferencesFactory;
import org.apache.lucene.luke.app.desktop.util.DialogOpener;
import org.apache.lucene.luke.app.desktop.util.FontUtils;
import org.apache.lucene.luke.app.desktop.util.ImageUtils;
import org.apache.lucene.luke.app.desktop.util.MessageUtils;
import org.apache.lucene.luke.app.desktop.util.StyleConstants;
import org.apache.lucene.luke.app.desktop.util.URLLabel;
import org.apache.lucene.luke.models.tools.IndexTools;
import org.apache.lucene.luke.models.tools.IndexToolsFactory;
import org.apache.lucene.luke.util.LoggerFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.NamedThreadFactory;
import org.apache.lucene.util.SuppressForbidden;

public class CreateIndexDialogFactory
implements DialogOpener.DialogFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static CreateIndexDialogFactory instance;
    private final Preferences prefs;
    private final IndexHandler indexHandler;
    private final JTextField locationTF = new JTextField();
    private final JButton browseBtn = new JButton();
    private final JTextField dirnameTF = new JTextField();
    private final JTextField dataDirTF = new JTextField();
    private final JButton dataBrowseBtn = new JButton();
    private final JButton clearBtn = new JButton();
    private final JLabel indicatorLbl = new JLabel();
    private final JButton createBtn = new JButton();
    private final JButton cancelBtn = new JButton();
    private final ListenerFunctions listeners = new ListenerFunctions();
    private JDialog dialog;

    public static synchronized CreateIndexDialogFactory getInstance() throws IOException {
        if (instance == null) {
            instance = new CreateIndexDialogFactory();
        }
        return instance;
    }

    private CreateIndexDialogFactory() throws IOException {
        this.prefs = PreferencesFactory.getInstance();
        this.indexHandler = IndexHandler.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.locationTF.setPreferredSize(new Dimension(360, 30));
        this.locationTF.setText(System.getProperty("user.home"));
        this.locationTF.setEditable(false);
        this.browseBtn.setText(FontUtils.elegantIconHtml("&#x6e;", MessageUtils.getLocalizedMessage("button.browse")));
        this.browseBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.browseBtn.setPreferredSize(new Dimension(120, 30));
        this.browseBtn.addActionListener(this.listeners::browseLocationDirectory);
        this.dirnameTF.setPreferredSize(new Dimension(200, 30));
        this.dataDirTF.setPreferredSize(new Dimension(250, 30));
        this.dataDirTF.setEditable(false);
        this.clearBtn.setText(MessageUtils.getLocalizedMessage("button.clear"));
        this.clearBtn.setPreferredSize(new Dimension(70, 30));
        this.clearBtn.addActionListener(x$0 -> this.listeners.clearDataDir(x$0));
        this.dataBrowseBtn.setText(FontUtils.elegantIconHtml("&#x6e;", MessageUtils.getLocalizedMessage("button.browse")));
        this.dataBrowseBtn.setFont(StyleConstants.FONT_BUTTON_LARGE);
        this.dataBrowseBtn.setPreferredSize(new Dimension(100, 30));
        this.dataBrowseBtn.addActionListener(this.listeners::browseDataDirectory);
        this.indicatorLbl.setIcon(ImageUtils.createImageIcon("indicator.gif", 20, 20));
        this.indicatorLbl.setVisible(false);
        this.createBtn.setText(MessageUtils.getLocalizedMessage("button.create"));
        this.createBtn.addActionListener(this.listeners::createIndex);
        this.cancelBtn.setText(MessageUtils.getLocalizedMessage("button.cancel"));
        this.cancelBtn.addActionListener(e -> this.dialog.dispose());
    }

    @Override
    public JDialog create(Window owner, String title, int width, int height) {
        this.dialog = new JDialog(owner, title, Dialog.ModalityType.APPLICATION_MODAL);
        this.dialog.add(this.content());
        this.dialog.setSize(new Dimension(width, height));
        this.dialog.setLocationRelativeTo(owner);
        this.dialog.getContentPane().setBackground(this.prefs.getColorTheme().getBackgroundColor());
        return this.dialog;
    }

    private JPanel content() {
        JPanel panel = new JPanel();
        panel.setOpaque(false);
        panel.setLayout(new BoxLayout(panel, 3));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.add(this.basicSettings());
        panel.add(new JSeparator(0));
        panel.add(this.optionalSettings());
        panel.add(new JSeparator(0));
        panel.add(this.buttons());
        return panel;
    }

    private JPanel basicSettings() {
        JPanel panel = new JPanel(new GridLayout(2, 1));
        panel.setOpaque(false);
        JPanel locPath = new JPanel(new FlowLayout(3));
        locPath.setOpaque(false);
        locPath.add(new JLabel(MessageUtils.getLocalizedMessage("createindex.label.location")));
        locPath.add(this.locationTF);
        locPath.add(this.browseBtn);
        panel.add(locPath);
        JPanel dirName = new JPanel(new FlowLayout(3));
        dirName.setOpaque(false);
        dirName.add(new JLabel(MessageUtils.getLocalizedMessage("createindex.label.dirname")));
        dirName.add(this.dirnameTF);
        panel.add(dirName);
        return panel;
    }

    private JPanel optionalSettings() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        JPanel description = new JPanel();
        description.setLayout(new BoxLayout(description, 1));
        description.setOpaque(false);
        JPanel name = new JPanel(new FlowLayout(3));
        name.setOpaque(false);
        JLabel nameLbl = new JLabel(MessageUtils.getLocalizedMessage("createindex.label.option"));
        name.add(nameLbl);
        description.add(name);
        JTextArea descTA1 = new JTextArea(MessageUtils.getLocalizedMessage("createindex.textarea.data_help1"));
        descTA1.setPreferredSize(new Dimension(550, 20));
        descTA1.setBorder(BorderFactory.createEmptyBorder(2, 10, 10, 5));
        descTA1.setOpaque(false);
        descTA1.setLineWrap(true);
        descTA1.setEditable(false);
        description.add(descTA1);
        JPanel link = new JPanel(new FlowLayout(3, 10, 1));
        link.setOpaque(false);
        JLabel linkLbl = FontUtils.toLinkText(new URLLabel(MessageUtils.getLocalizedMessage("createindex.label.data_link")));
        link.add(linkLbl);
        description.add(link);
        JTextArea descTA2 = new JTextArea(MessageUtils.getLocalizedMessage("createindex.textarea.data_help2"));
        descTA2.setPreferredSize(new Dimension(550, 50));
        descTA2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 5));
        descTA2.setOpaque(false);
        descTA2.setLineWrap(true);
        descTA2.setEditable(false);
        description.add(descTA2);
        panel.add((Component)description, "First");
        JPanel dataDirPath = new JPanel(new FlowLayout(3));
        dataDirPath.setOpaque(false);
        dataDirPath.add(new JLabel(MessageUtils.getLocalizedMessage("createindex.label.datadir")));
        dataDirPath.add(this.dataDirTF);
        dataDirPath.add(this.dataBrowseBtn);
        dataDirPath.add(this.clearBtn);
        panel.add((Component)dataDirPath, "Center");
        return panel;
    }

    private JPanel buttons() {
        JPanel panel = new JPanel(new FlowLayout(4));
        panel.setOpaque(false);
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 10, 20));
        panel.add(this.indicatorLbl);
        panel.add(this.createBtn);
        panel.add(this.cancelBtn);
        return panel;
    }

    private class ListenerFunctions {
        private ListenerFunctions() {
        }

        void browseLocationDirectory(ActionEvent e) {
            this.browseDirectory(CreateIndexDialogFactory.this.locationTF);
        }

        void browseDataDirectory(ActionEvent e) {
            this.browseDirectory(CreateIndexDialogFactory.this.dataDirTF);
        }

        @SuppressForbidden(reason="JFilechooser#getSelectedFile() returns java.io.File")
        private void browseDirectory(JTextField tf) {
            JFileChooser fc = new JFileChooser(new File(tf.getText()));
            fc.setFileSelectionMode(1);
            fc.setFileHidingEnabled(false);
            int retVal = fc.showOpenDialog(CreateIndexDialogFactory.this.dialog);
            if (retVal == 0) {
                File dir = fc.getSelectedFile();
                tf.setText(dir.getAbsolutePath());
            }
        }

        void createIndex(ActionEvent e) {
            final Path path = Paths.get(CreateIndexDialogFactory.this.locationTF.getText(), CreateIndexDialogFactory.this.dirnameTF.getText());
            if (Files.exists(path, new LinkOption[0])) {
                String message = "The directory " + path.toAbsolutePath().toString() + " already exists.";
                JOptionPane.showMessageDialog(CreateIndexDialogFactory.this.dialog, message, "Empty index path", 0);
            } else {
                ExecutorService executor = Executors.newFixedThreadPool(1, (ThreadFactory)new NamedThreadFactory("create-index-dialog"));
                SwingWorker<Void, Void> task = new SwingWorker<Void, Void>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    protected Void doInBackground() throws Exception {
                        this.setProgress(0);
                        CreateIndexDialogFactory.this.indicatorLbl.setVisible(true);
                        CreateIndexDialogFactory.this.createBtn.setEnabled(false);
                        try {
                            FSDirectory dir = FSDirectory.open((Path)path);
                            IndexTools toolsModel = new IndexToolsFactory().newInstance((Directory)dir);
                            if (CreateIndexDialogFactory.this.dataDirTF.getText().isEmpty()) {
                                toolsModel.createNewIndex();
                            } else {
                                Path dataPath = Paths.get(CreateIndexDialogFactory.this.dataDirTF.getText(), new String[0]);
                                toolsModel.createNewIndex(dataPath.toAbsolutePath().toString());
                            }
                            CreateIndexDialogFactory.this.indexHandler.open(path.toAbsolutePath().toString(), null, false, false, false);
                            CreateIndexDialogFactory.this.prefs.addHistory(path.toAbsolutePath().toString());
                            CreateIndexDialogFactory.this.dirnameTF.setText("");
                            ListenerFunctions.this.closeDialog();
                        }
                        catch (Exception ex) {
                            try {
                                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        Files.delete(file);
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                                Files.deleteIfExists(path);
                            }
                            catch (IOException toolsModel) {
                                // empty catch block
                            }
                            log.log(Level.SEVERE, "Cannot create index", ex);
                            String message = "See Logs tab for more details.";
                            JOptionPane.showMessageDialog(CreateIndexDialogFactory.this.dialog, message, "Cannot create index", 0);
                        }
                        finally {
                            this.setProgress(100);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        CreateIndexDialogFactory.this.indicatorLbl.setVisible(false);
                        CreateIndexDialogFactory.this.createBtn.setEnabled(true);
                    }
                };
                executor.submit(task);
                executor.shutdown();
            }
        }

        private void clearDataDir(ActionEvent e) {
            CreateIndexDialogFactory.this.dataDirTF.setText("");
        }

        private void closeDialog() {
            CreateIndexDialogFactory.this.dialog.dispose();
        }
    }
}

