/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.service.authentication.ldap;

import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.service.authentication.ldap.DirSearch;
import org.apache.kyuubi.service.authentication.ldap.DirSearchFactory;
import org.apache.kyuubi.service.authentication.ldap.LdapSearch;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra\u0001\u0002\u0003\u0006\u0001IAQ!\t\u0001\u0005\u0002\tBQ\u0001\n\u0001\u0005B\u0015BQ!\u001b\u0001\u0005\n)\u0014\u0011\u0003\u00143baN+\u0017M]2i\r\u0006\u001cGo\u001c:z\u0015\t1q!\u0001\u0003mI\u0006\u0004(B\u0001\u0005\n\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!AC\u0006\u0002\u000fM,'O^5dK*\u0011A\"D\u0001\u0007Wf,XOY5\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\u0011\u00011#G\u000f\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQ2$D\u0001\u0006\u0013\taRA\u0001\tESJ\u001cV-\u0019:dQ\u001a\u000b7\r^8ssB\u0011adH\u0007\u0002\u0017%\u0011\u0001e\u0003\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002\u001b\u0001\u0005Yq-\u001a;J]N$\u0018M\\2f)\u00111\u0013&\r \u0011\u0005i9\u0013B\u0001\u0015\u0006\u0005%!\u0015N]*fCJ\u001c\u0007\u000eC\u0003+\u0005\u0001\u00071&\u0001\u0003d_:4\u0007C\u0001\u00170\u001b\u0005i#B\u0001\u0018\f\u0003\u0019\u0019wN\u001c4jO&\u0011\u0001'\f\u0002\u000b\u0017f,XOY5D_:4\u0007\"\u0002\u001a\u0003\u0001\u0004\u0019\u0014!\u00039sS:\u001c\u0017\u000e]1m!\t!4H\u0004\u00026sA\u0011a'F\u0007\u0002o)\u0011\u0001(E\u0001\u0007yI|w\u000e\u001e \n\u0005i*\u0012A\u0002)sK\u0012,g-\u0003\u0002={\t11\u000b\u001e:j]\u001eT!AO\u000b\t\u000b}\u0012\u0001\u0019A\u001a\u0002\u0011A\f7o]<pe\u0012D3AA!O!\r!\"\tR\u0005\u0003\u0007V\u0011a\u0001\u001e5s_^\u001c\bCA#M\u001b\u00051%BA$I\u0003\u0011\u0019\u0018m\u001d7\u000b\u0005%S\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003-\u000bQA[1wCbL!!\u0014$\u0003/\u0005+H\u000f[3oi&\u001c\u0017\r^5p]\u0016C8-\u001a9uS>t\u0017\u0007\u0002\u00104\u001f\"\fTa\t)UGV+\"!\u0015*\u0016\u0003M\"QaU\tC\u0002a\u0013\u0011\u0001V\u0005\u0003+Z\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$BA,\u0016\u0003\u0019!\bN]8xgF\u0011\u0011\f\u0018\t\u0003)iK!aW\u000b\u0003\u000f9{G\u000f[5oOB\u0011Q\f\u0019\b\u0003)yK!aX\u000b\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\n)\"\u0014xn^1cY\u0016T!aX\u000b2\u000b\r\"WMZ,\u000f\u0005Q)\u0017BA,\u0016c\u0011\u0011C#F4\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019\"\u0015\u0001E2sK\u0006$X\rR5s\u0007>tG/\u001a=u)\u0011Y7\u000f^;\u0011\u00051\fX\"A7\u000b\u00059|\u0017!\u00033je\u0016\u001cGo\u001c:z\u0015\t\u0001(*\u0001\u0004oC6LgnZ\u0005\u0003e6\u0014!\u0002R5s\u0007>tG/\u001a=u\u0011\u0015Q3\u00011\u0001,\u0011\u0015\u00114\u00011\u00014\u0011\u0015y4\u00011\u00014Q\r\u0019q\u000f \t\u0004)\tC\bCA={\u001b\u0005y\u0017BA>p\u0005=q\u0015-\\5oO\u0016C8-\u001a9uS>t\u0017'\u0002\u00104{\u0006\u0005\u0011'B\u0012Q)z,\u0016'B\u0012eK~<\u0016\u0007\u0002\u0012\u0015+\u001d\f$A\n=")
public class LdapSearchFactory
implements DirSearchFactory,
Logging {
    private transient Logger org$apache$kyuubi$Logging$$log_;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public Logger logger() {
        return Logging.logger$(this);
    }

    @Override
    public void debug(Function0<Object> message) {
        Logging.debug$(this, message);
    }

    @Override
    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$(this, message, t);
    }

    @Override
    public void info(Function0<Object> message) {
        Logging.info$(this, message);
    }

    @Override
    public void info(Function0<Object> message, Throwable t) {
        Logging.info$(this, message, t);
    }

    @Override
    public void warn(Function0<Object> message) {
        Logging.warn$(this, message);
    }

    @Override
    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message, Throwable t) {
        Logging.error$(this, message, t);
    }

    @Override
    public void error(Function0<Object> message) {
        Logging.error$(this, message);
    }

    @Override
    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$(this, isInterpreter);
    }

    @Override
    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    @Override
    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public DirSearch getInstance(KyuubiConf conf, String principal, String password) throws AuthenticationException {
        LdapSearch ldapSearch;
        try {
            DirContext ctx = this.createDirContext(conf, principal, password);
            ldapSearch = new LdapSearch(conf, ctx);
        }
        catch (NamingException e) {
            this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Could not connect to the LDAP Server: Authentication failed for ").append(principal).toString());
            throw new AuthenticationException(new StringBuilder(28).append("Error validating LDAP user: ").append(principal).toString(), e);
        }
        return ldapSearch;
    }

    private DirContext createDirContext(KyuubiConf conf, String principal, String password) throws NamingException {
        Option ldapUrl = (Option)((Object)conf.get(KyuubiConf$.MODULE$.AUTHENTICATION_LDAP_URL()));
        Hashtable<String, String> env = new Hashtable<String, String>();
        ldapUrl.foreach((Function1<String, Object> & Serializable & scala.Serializable)x$1 -> env.put("java.naming.provider.url", (String)x$1));
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", password);
        this.debug((Function0<Object>)(Function0<String> & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Connecting using principal ").append(principal).append(" to ldap server: ").append(ldapUrl.orNull(Predef$.MODULE$.$conforms())).toString());
        return new InitialDirContext(env);
    }

    public LdapSearchFactory() {
        Logging.$init$(this);
    }
}

