/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.avltree;

import java.io.IOException;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.avltree.AvlTreeMap;
import org.apache.directory.server.core.avltree.LinkedAvlMapNode;
import org.apache.directory.server.core.avltree.Position;
import org.apache.directory.server.core.avltree.SingletonOrOrderedSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvlSingletonOrOrderedSetCursor<K, V>
extends AbstractCursor<Tuple<K, SingletonOrOrderedSet<V>>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger((String)Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private AvlTreeMap<K, V> tree;
    private LinkedAvlMapNode<K, V> node;
    private Position position = Position.BEFORE_FIRST;
    private Tuple<K, SingletonOrOrderedSet<V>> returnedTuple = new Tuple();

    public AvlSingletonOrOrderedSetCursor(AvlTreeMap<K, V> tree) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AvlSingletonOrOrderedSetCursor {}", (Object)this);
        }
        this.tree = tree;
    }

    public Comparator<K> getKeyComparator() {
        return this.tree.getKeyComparator();
    }

    public Comparator<V> getValuComparator() {
        return this.tree.getValueComparator();
    }

    public void after(Tuple<K, SingletonOrOrderedSet<V>> element) throws LdapException, CursorException {
        this.afterKey(element.getKey());
    }

    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = null;
        this.position = Position.AFTER_LAST;
    }

    public boolean available() {
        return this.position == Position.ON_NODE;
    }

    public void before(Tuple<K, SingletonOrOrderedSet<V>> element) throws LdapException, CursorException {
        this.beforeKey(element.getKey());
    }

    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = null;
        this.position = Position.BEFORE_FIRST;
    }

    public boolean first() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = this.tree.getFirst();
        if (this.node == null) {
            this.position = Position.BEFORE_FIRST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    public Tuple<K, SingletonOrOrderedSet<V>> get() throws CursorException {
        this.checkNotClosed();
        if (this.position == Position.ON_NODE) {
            this.returnedTuple.setKey(this.node.key);
            this.returnedTuple.setValue(this.node.value);
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    public boolean last() throws LdapException, CursorException {
        this.checkNotClosed();
        this.node = this.tree.getLast();
        if (this.node == null) {
            this.position = Position.AFTER_LAST;
            return false;
        }
        this.position = Position.ON_NODE;
        return true;
    }

    public boolean next() throws LdapException, CursorException {
        this.checkNotClosed();
        switch (this.position) {
            case BEFORE_FIRST: {
                return this.first();
            }
            case BEFORE_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case ON_NODE: 
            case AFTER_NODE: {
                this.node = this.node.next;
                if (this.node == null) {
                    this.afterLast();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return false;
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    public boolean previous() throws LdapException, CursorException {
        this.checkNotClosed();
        switch (this.position) {
            case BEFORE_FIRST: {
                return false;
            }
            case BEFORE_NODE: 
            case ON_NODE: {
                this.node = this.node.previous;
                if (this.node == null) {
                    this.beforeFirst();
                    return false;
                }
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_NODE: {
                this.position = Position.ON_NODE;
                return true;
            }
            case AFTER_LAST: {
                return this.last();
            }
        }
        throw new IllegalStateException("Unexpected position " + (Object)((Object)this.position));
    }

    public void afterKey(K key) throws LdapException, CursorException {
        this.checkNotClosed();
        if (key == null) {
            this.afterLast();
            return;
        }
        this.node = this.tree.findGreater(key);
        this.position = this.node == null ? Position.AFTER_LAST : Position.BEFORE_NODE;
    }

    public void afterValue(K key, SingletonOrOrderedSet<V> value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    public void beforeKey(K key) throws LdapException, CursorException {
        this.checkNotClosed();
        if (key == null) {
            this.beforeFirst();
            return;
        }
        this.node = this.tree.findLess(key);
        this.position = this.node == null ? Position.BEFORE_FIRST : Position.AFTER_NODE;
    }

    public void beforeValue(K key, SingletonOrOrderedSet<V> value) throws Exception {
        throw new UnsupportedOperationException("This Cursor does not support duplicate keys.");
    }

    public void close() throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlSingletonOrOrderedSetCursor {}", (Object)this);
        }
        super.close();
    }

    public void close(Exception reason) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AvlSingletonOrOrderedSetCursor {}", (Object)this);
        }
        super.close(reason);
    }
}

