/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.logback.internal.spi;

import ch.qos.logback.classic.Level;
import org.ops4j.pax.logging.spi.PaxLevel;
import org.osgi.service.log.LogLevel;

public class PaxLevelImpl
implements PaxLevel {
    public static final int SYSLOG_ALL = 7;
    public static final int SYSLOG_TRACE = 7;
    public static final int SYSLOG_DEBUG = 7;
    public static final int SYSLOG_INFO = 6;
    public static final int SYSLOG_WARN = 4;
    public static final int SYSLOG_ERROR = 3;
    public static final int SYSLOG_FATAL = 0;
    public static final int SYSLOG_OFF = 0;
    private Level m_delegate;

    public PaxLevelImpl(Level delegate) {
        this.m_delegate = delegate;
    }

    public boolean isGreaterOrEqual(PaxLevel r) {
        if (r instanceof PaxLevelImpl) {
            PaxLevelImpl impl = (PaxLevelImpl)r;
            return this.m_delegate.isGreaterOrEqual(impl.m_delegate);
        }
        return this.getSyslogEquivalent() <= r.getSyslogEquivalent();
    }

    public LogLevel toLevel() {
        if (this.m_delegate.isGreaterOrEqual(Level.ERROR)) {
            return LogLevel.ERROR;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.WARN)) {
            return LogLevel.WARN;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.INFO)) {
            return LogLevel.INFO;
        }
        if (this.m_delegate.isGreaterOrEqual(Level.DEBUG)) {
            return LogLevel.DEBUG;
        }
        return LogLevel.TRACE;
    }

    public int getSyslogEquivalent() {
        if (this.m_delegate == Level.TRACE) {
            return 7;
        }
        if (this.m_delegate == Level.DEBUG) {
            return 7;
        }
        if (this.m_delegate == Level.INFO) {
            return 6;
        }
        if (this.m_delegate == Level.WARN) {
            return 4;
        }
        if (this.m_delegate == Level.ERROR) {
            return 3;
        }
        if (this.m_delegate == Level.OFF) {
            return 0;
        }
        if (this.m_delegate == Level.ALL) {
            return 7;
        }
        return 7;
    }

    public String toString() {
        return this.m_delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaxLevelImpl that = (PaxLevelImpl)o;
        return this.m_delegate.equals(that.m_delegate);
    }

    public int hashCode() {
        return this.m_delegate.hashCode();
    }
}

