/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionActivationListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.Invocable;

public class SessionHandler
extends AbstractSessionManager
implements Handler.Singleton {
    public static final EnumSet<SessionTrackingMode> DEFAULT_SESSION_TRACKING_MODES = EnumSet.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
    final List<HttpSessionAttributeListener> _sessionAttributeListeners = new CopyOnWriteArrayList<HttpSessionAttributeListener>();
    final List<HttpSessionListener> _sessionListeners = new CopyOnWriteArrayList<HttpSessionListener>();
    final List<HttpSessionIdListener> _sessionIdListeners = new CopyOnWriteArrayList<HttpSessionIdListener>();
    private final SessionCookieConfig _cookieConfig = new CookieConfig();
    private Server _server;
    private Handler _handler;

    public void setServer(Server server) {
        this._server = server;
        Handler handler = this.getHandler();
        if (handler != null) {
            handler.setServer(server);
        }
    }

    public Invocable.InvocationType getInvocationType() {
        return Invocable.InvocationType.BLOCKING;
    }

    public Handler getHandler() {
        return this._handler;
    }

    public void setHandler(Handler handler) {
        this._handler = Handler.Singleton.updateHandler((Handler.Singleton)this, (Handler)handler);
    }

    public Server getServer() {
        return this._server;
    }

    public SessionHandler() {
        this.setSessionTrackingModes(DEFAULT_SESSION_TRACKING_MODES);
        this.installBean(this._cookieConfig);
        this.installBean(this._sessionListeners);
        this.installBean(this._sessionIdListeners);
        this.installBean(this._sessionAttributeListeners);
    }

    public ManagedSession getManagedSession(Request request) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (servletContextRequest != null) {
            return servletContextRequest.getManagedSession();
        }
        NonServletSessionRequest nonServletSessionRequest = (NonServletSessionRequest)((Object)Request.as((Request)request, NonServletSessionRequest.class));
        if (nonServletSessionRequest != null) {
            return nonServletSessionRequest.getManagedSession();
        }
        Session session = request.getSession(false);
        if (session instanceof ManagedSession) {
            ManagedSession managedSession = (ManagedSession)session;
            return managedSession;
        }
        return null;
    }

    public boolean addEventListener(EventListener listener) {
        if (super.addEventListener(listener)) {
            if (listener instanceof HttpSessionAttributeListener) {
                this._sessionAttributeListeners.add((HttpSessionAttributeListener)listener);
            }
            if (listener instanceof HttpSessionListener) {
                this._sessionListeners.add((HttpSessionListener)listener);
            }
            if (listener instanceof HttpSessionIdListener) {
                this._sessionIdListeners.add((HttpSessionIdListener)listener);
            }
            return true;
        }
        return false;
    }

    public boolean removeEventListener(EventListener listener) {
        if (super.removeEventListener(listener)) {
            if (listener instanceof HttpSessionAttributeListener) {
                this._sessionAttributeListeners.remove(listener);
            }
            if (listener instanceof HttpSessionListener) {
                this._sessionListeners.remove(listener);
            }
            if (listener instanceof HttpSessionIdListener) {
                this._sessionIdListeners.remove(listener);
            }
            return true;
        }
        return false;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.configureCookies();
    }

    protected void configureCookies() {
        ServletContextHandler contextHandler = ServletContextHandler.getCurrentServletContextHandler();
        if (contextHandler == null) {
            return;
        }
        String tmp = contextHandler.getInitParameter("org.eclipse.jetty.session.SessionCookie");
        if (tmp != null) {
            this.setSessionCookie(tmp);
        }
        if ((tmp = contextHandler.getInitParameter("org.eclipse.jetty.session.SessionIdPathParameterName")) != null) {
            this.setSessionIdPathParameterName(tmp);
        }
        if ((tmp = contextHandler.getInitParameter("org.eclipse.jetty.session.CheckingRemoteSessionIdEncoding")) != null) {
            this.setCheckingRemoteSessionIdEncoding(Boolean.parseBoolean(tmp));
        }
        if ((tmp = contextHandler.getInitParameter("org.eclipse.jetty.session.SessionDomain")) != null) {
            this.setSessionDomain(tmp);
        }
        if ((tmp = contextHandler.getInitParameter("org.eclipse.jetty.session.SessionPath")) != null) {
            this.setSessionPath(tmp);
        }
        if ((tmp = contextHandler.getInitParameter("org.eclipse.jetty.session.MaxAge")) != null) {
            this.setMaxCookieAge(Integer.parseInt(tmp.trim()));
        }
    }

    public Session.API newSessionAPIWrapper(ManagedSession session) {
        return ServletSessionApi.wrapSession(session);
    }

    public void onSessionAttributeUpdate(Session session, String name, Object old, Object value) {
        if (old != null) {
            this.callUnboundBindingListener(session, name, old);
        }
        if (value != null) {
            this.callBoundBindingListener(session, name, value);
        }
        if (!this._sessionAttributeListeners.isEmpty()) {
            HttpSessionBindingEvent event = new HttpSessionBindingEvent((HttpSession)session.getApi(), name, old == null ? value : old);
            for (HttpSessionAttributeListener l : this._sessionAttributeListeners) {
                if (old == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (value == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void onSessionCreated(Session session) {
        if (session == null) {
            return;
        }
        super.onSessionCreated(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
        for (HttpSessionListener l : this._sessionListeners) {
            l.sessionCreated(event);
        }
    }

    public void onSessionDestroyed(Session session) {
        if (session == null) {
            return;
        }
        super.onSessionDestroyed(session);
        this.getSessionContext().run(() -> {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
            ListIterator i = TypeUtil.listIteratorAtEnd(this._sessionListeners);
            while (i.hasPrevious()) {
                ((HttpSessionListener)i.previous()).sessionDestroyed(event);
            }
        });
    }

    public void onSessionIdChanged(Session session, String oldId) {
        super.onSessionIdChanged(session, oldId);
        if (!this._sessionIdListeners.isEmpty()) {
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
            for (HttpSessionIdListener l : this._sessionIdListeners) {
                l.sessionIdChanged(event, oldId);
            }
        }
    }

    protected void callUnboundBindingListener(Session session, String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueUnbound(new HttpSessionBindingEvent((HttpSession)session.getApi(), name));
        }
    }

    protected void callBoundBindingListener(Session session, String name, Object value) {
        if (value instanceof HttpSessionBindingListener) {
            ((HttpSessionBindingListener)value).valueBound(new HttpSessionBindingEvent((HttpSession)session.getApi(), name));
        }
    }

    public void onSessionActivation(Session session) {
        for (String name : session.getAttributeNameSet()) {
            Object value = session.getAttribute(name);
            if (!(value instanceof HttpSessionActivationListener)) continue;
            HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
            listener.sessionDidActivate(event);
        }
    }

    public void onSessionPassivation(Session session) {
        for (String name : session.getAttributeNameSet()) {
            Object value = session.getAttribute(name);
            if (!(value instanceof HttpSessionActivationListener)) continue;
            HttpSessionActivationListener listener = (HttpSessionActivationListener)value;
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)session.getApi());
            listener.sessionWillPassivate(event);
        }
    }

    public SessionCookieConfig getSessionCookieConfig() {
        return this._cookieConfig;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return DEFAULT_SESSION_TRACKING_MODES;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.isUsingCookies()) {
            if (this.isUsingUriParameters()) {
                return Set.of(SessionTrackingMode.COOKIE, SessionTrackingMode.URL);
            }
            return Set.of(SessionTrackingMode.COOKIE);
        }
        if (this.isUsingUriParameters()) {
            return Set.of(SessionTrackingMode.URL);
        }
        return Collections.emptySet();
    }

    public HttpCookie.SameSite getSameSite() {
        String sameSite = this.getSessionCookieAttribute("SameSite");
        if (sameSite == null) {
            return null;
        }
        return HttpCookie.SameSite.valueOf((String)sameSite.toUpperCase(Locale.ENGLISH));
    }

    public void setSameSite(HttpCookie.SameSite sameSite) {
        this.setSessionCookieAttribute("SameSite", sameSite.getAttributeValue());
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        if (sessionTrackingModes != null && sessionTrackingModes.size() > 1 && sessionTrackingModes.contains(SessionTrackingMode.SSL)) {
            throw new IllegalArgumentException("sessionTrackingModes specifies a combination of SessionTrackingMode.SSL with a session tracking mode other than SessionTrackingMode.SSL");
        }
        this.setUsingCookies(sessionTrackingModes != null && sessionTrackingModes.contains(SessionTrackingMode.COOKIE));
        this.setUsingUriParameters(sessionTrackingModes != null && sessionTrackingModes.contains(SessionTrackingMode.URL));
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        Handler next = this.getHandler();
        if (next == null) {
            return false;
        }
        this.addSessionStreamWrapper((Request)request);
        AbstractSessionManager.RequestedSession requestedSession = this.resolveRequestedSessionId((Request)request);
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        if (servletContextRequest == null) {
            request = new NonServletSessionRequest((Request)request, response, requestedSession);
        } else {
            servletContextRequest.setRequestedSession(requestedSession);
        }
        HttpCookie cookie = this.access(requestedSession.session(), request.getConnectionMetaData().isSecure());
        if (cookie != null) {
            Response.putCookie((Response)response, (HttpCookie)cookie);
        }
        return next.handle(request, response, callback);
    }

    public final class CookieConfig
    implements SessionCookieConfig {
        public String getComment() {
            return SessionHandler.this.getSessionComment();
        }

        public String getDomain() {
            return SessionHandler.this.getSessionDomain();
        }

        public int getMaxAge() {
            return SessionHandler.this.getMaxCookieAge();
        }

        public void setAttribute(String name, String value) {
            String lcase;
            this.checkState();
            switch (lcase = name.toLowerCase(Locale.ENGLISH)) {
                case "name": {
                    this.setName(value);
                    break;
                }
                case "max-age": {
                    this.setMaxAge(value == null ? -1 : Integer.parseInt(value));
                    break;
                }
                case "comment": {
                    this.setComment(value);
                    break;
                }
                case "domain": {
                    this.setDomain(value);
                    break;
                }
                case "httponly": {
                    this.setHttpOnly(Boolean.parseBoolean(value));
                    break;
                }
                case "secure": {
                    this.setSecure(Boolean.parseBoolean(value));
                    break;
                }
                case "path": {
                    this.setPath(value);
                    break;
                }
                default: {
                    SessionHandler.this.setSessionCookieAttribute(name, value);
                }
            }
        }

        public String getAttribute(String name) {
            String lcase;
            return switch (lcase = name.toLowerCase(Locale.ENGLISH)) {
                case "name" -> this.getName();
                case "max-age" -> Integer.toString(this.getMaxAge());
                case "comment" -> this.getComment();
                case "domain" -> this.getDomain();
                case "httponly" -> String.valueOf(this.isHttpOnly());
                case "secure" -> String.valueOf(this.isSecure());
                case "path" -> this.getPath();
                default -> SessionHandler.this.getSessionCookieAttribute(name);
            };
        }

        public Map<String, String> getAttributes() {
            TreeMap<String, String> specials = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            specials.put("name", this.getAttribute("name"));
            specials.put("max-age", this.getAttribute("max-age"));
            specials.put("comment", this.getAttribute("comment"));
            specials.put("domain", this.getAttribute("domain"));
            specials.put("httponly", this.getAttribute("httponly"));
            specials.put("secure", this.getAttribute("secure"));
            specials.put("path", this.getAttribute("path"));
            specials.putAll(SessionHandler.this.getSessionCookieAttributes());
            return Collections.unmodifiableMap(specials);
        }

        public String getName() {
            return SessionHandler.this.getSessionCookie();
        }

        public String getPath() {
            return SessionHandler.this.getSessionPath();
        }

        public boolean isHttpOnly() {
            return SessionHandler.this.isHttpOnly();
        }

        public boolean isSecure() {
            return SessionHandler.this.isSecureCookies();
        }

        public void setComment(String comment) {
            this.checkState();
            SessionHandler.this.setSessionComment(comment);
        }

        public void setDomain(String domain) {
            this.checkState();
            SessionHandler.this.setSessionDomain(domain);
        }

        public void setHttpOnly(boolean httpOnly) {
            this.checkState();
            SessionHandler.this.setHttpOnly(httpOnly);
        }

        public void setMaxAge(int maxAge) {
            this.checkState();
            SessionHandler.this.setMaxCookieAge(maxAge);
        }

        public void setName(String name) {
            this.checkState();
            SessionHandler.this.setSessionCookie(name);
        }

        public void setPath(String path) {
            this.checkState();
            SessionHandler.this.setSessionPath(path);
        }

        public void setSecure(boolean secure) {
            this.checkState();
            SessionHandler.this.setSecureCookies(secure);
        }

        public String toString() {
            return String.format("%s@%x[name=%s,domain=%s,path=%s,max-age=%d,secure=%b,http-only=%b,comment=%s,attributes=%s]", this.getClass().getName(), this.hashCode(), this.getName(), this.getDomain(), this.getPath(), this.getMaxAge(), this.isSecure(), this.isHttpOnly(), this.getComment(), SessionHandler.this.getSessionCookieAttributes().toString());
        }

        private void checkState() {
            ServletContextHandler handler = ServletContextHandler.getCurrentServletContextHandler();
            if (handler != null && handler.isAvailable()) {
                throw new IllegalStateException("CookieConfig cannot be set after ServletContext is started");
            }
        }
    }

    private class NonServletSessionRequest
    extends Request.Wrapper {
        private final Response _response;
        private AbstractSessionManager.RequestedSession _session;

        public NonServletSessionRequest(Request request, Response response, AbstractSessionManager.RequestedSession requestedSession) {
            super(request);
            this._response = response;
            this._session = requestedSession;
        }

        public Session getSession(boolean create) {
            ManagedSession session = this._session.session();
            if (session != null || !create) {
                return session;
            }
            SessionHandler.this.newSession(this.getWrapped(), this._session.sessionId(), ms -> {
                this._session = new AbstractSessionManager.RequestedSession(ms, this._session.sessionId(), true);
            });
            session = this._session.session();
            if (session == null) {
                throw new IllegalStateException("Create session failed");
            }
            HttpCookie cookie = SessionHandler.this.getSessionCookie(session, this.isSecure());
            if (cookie != null) {
                Response.replaceCookie((Response)this._response, (HttpCookie)cookie);
            }
            return session;
        }

        ManagedSession getManagedSession() {
            return this._session.session();
        }
    }

    public static class ServletSessionApi
    implements HttpSession,
    Session.API {
        private final ManagedSession _session;

        public static ServletSessionApi wrapSession(ManagedSession session) {
            return new ServletSessionApi(session);
        }

        public static ManagedSession getSession(HttpSession httpSession) {
            if (httpSession instanceof ServletSessionApi) {
                ServletSessionApi apiSession = (ServletSessionApi)httpSession;
                return apiSession.getSession();
            }
            return null;
        }

        private ServletSessionApi(ManagedSession session) {
            this._session = session;
        }

        public ManagedSession getSession() {
            return this._session;
        }

        public long getCreationTime() {
            return this._session.getCreationTime();
        }

        public String getId() {
            return this._session.getId();
        }

        public long getLastAccessedTime() {
            return this._session.getLastAccessedTime();
        }

        public ServletContext getServletContext() {
            return ServletContextHandler.getServletContext(this._session.getSessionManager().getContext());
        }

        public void setMaxInactiveInterval(int interval) {
            this._session.setMaxInactiveInterval(interval);
        }

        public int getMaxInactiveInterval() {
            return this._session.getMaxInactiveInterval();
        }

        public Object getAttribute(String name) {
            return this._session.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            final Iterator itor = this._session.getAttributeNameSet().iterator();
            return new Enumeration<String>(this){
                final /* synthetic */ ServletSessionApi this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public boolean hasMoreElements() {
                    return itor.hasNext();
                }

                @Override
                public String nextElement() {
                    return (String)itor.next();
                }
            };
        }

        public void setAttribute(String name, Object value) {
            this._session.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this._session.removeAttribute(name);
        }

        public void invalidate() {
            this._session.invalidate();
        }

        public boolean isNew() {
            return this._session.isNew();
        }
    }
}

