/*
 * Decompiled with CFR 0.152.
 */
package kafka.log.remote.quota;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.log.remote.quota.RLMQuotaManagerConfig;
import kafka.server.QuotaType;
import kafka.server.SensorAccess;
import kafka.utils.QuotaUtils;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.SimpleRate;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.runtime.BoxedUnit;

public class RLMQuotaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RLMQuotaManager.class);
    private final RLMQuotaManagerConfig config;
    private final Metrics metrics;
    private final QuotaType quotaType;
    private final String description;
    private final Time time;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final SensorAccess sensorAccess;
    private Quota quota;

    public RLMQuotaManager(RLMQuotaManagerConfig config, Metrics metrics, QuotaType quotaType, String description, Time time) {
        this.config = config;
        this.metrics = metrics;
        this.quotaType = quotaType;
        this.description = description;
        this.time = time;
        this.quota = new Quota((double)config.quotaBytesPerSecond(), true);
        this.sensorAccess = new SensorAccess(this.lock, metrics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateQuota(Quota newQuota) {
        this.lock.writeLock().lock();
        try {
            this.quota = newQuota;
            Map allMetrics = this.metrics.metrics();
            MetricName quotaMetricName = this.metricName();
            KafkaMetric metric = (KafkaMetric)allMetrics.get(quotaMetricName);
            if (metric != null) {
                LOGGER.info("Sensor for quota-id {} already exists. Setting quota to {} in MetricConfig", (Object)quotaMetricName, (Object)newQuota);
                metric.config(this.getQuotaMetricConfig(newQuota));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public long getThrottleTimeMs() {
        Sensor sensorInstance = this.sensor();
        try {
            sensorInstance.checkQuotas();
        }
        catch (QuotaViolationException qve) {
            LOGGER.debug("Quota violated for sensor ({}), metric: ({}), metric-value: ({}), bound: ({})", new Object[]{sensorInstance.name(), qve.metric().metricName(), qve.value(), qve.bound()});
            return QuotaUtils.throttleTime(qve, this.time.milliseconds());
        }
        return 0L;
    }

    public void record(double value) {
        this.sensor().record(value, this.time.milliseconds(), false);
    }

    private MetricConfig getQuotaMetricConfig(Quota quota) {
        return new MetricConfig().timeWindow((long)this.config.quotaWindowSizeSeconds(), TimeUnit.SECONDS).samples(this.config.numQuotaSamples()).quota(quota);
    }

    private MetricName metricName() {
        return this.metrics.metricName("byte-rate", this.quotaType.toString(), this.description, Collections.emptyMap());
    }

    private Sensor sensor() {
        return this.sensorAccess.getOrCreate(this.quotaType.toString(), 3600L, (Function1<Sensor, BoxedUnit>)((Function1)sensor -> {
            sensor.add(this.metricName(), (MeasurableStat)new SimpleRate(), this.getQuotaMetricConfig(this.quota));
            return BoxedUnit.UNIT;
        }));
    }
}

