/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.httppart;

import jakarta.servlet.http.Part;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.NameValuePair;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.ArgUtils;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.HttpParts;
import org.apache.juneau.http.header.ContentType;
import org.apache.juneau.http.part.BasicStringPart;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.httppart.RequestContent;
import org.apache.juneau.rest.httppart.RequestFormParam;
import org.apache.juneau.rest.httppart.RequestHttpPart;
import org.apache.juneau.rest.util.RestUtils;
import org.apache.juneau.svl.VarResolverSession;

public class RequestFormParams
extends ArrayList<RequestFormParam> {
    private static final long serialVersionUID = 1L;
    private final RestRequest req;
    private boolean caseSensitive;
    private HttpPartParserSession parser;
    private final VarResolverSession vs;

    public RequestFormParams(RestRequest req, boolean caseSensitive) throws Exception {
        this.req = req;
        this.caseSensitive = caseSensitive;
        this.vs = req.getVarResolverSession();
        Map m = null;
        Collection c = null;
        RequestContent content = req.getContent();
        if (content.isLoaded() || !req.getHeader(ContentType.class).orElse(ContentType.NULL).equalsIgnoreCase("multipart/form-data")) {
            m = RestUtils.parseQuery(content.getReader());
        } else {
            c = req.getHttpServletRequest().getParts();
            if (c == null || c.isEmpty()) {
                m = req.getHttpServletRequest().getParameterMap();
            }
        }
        if (m != null) {
            for (Map.Entry<String, String[]> e : m.entrySet()) {
                String name = e.getKey();
                String[] values = e.getValue();
                if (values == null) {
                    values = new String[]{};
                }
                if (values.length == 1 && values[0] == null) {
                    values[0] = "";
                }
                if (values.length == 0) {
                    values = new String[]{null};
                }
                for (String value : values) {
                    this.add(new RequestFormParam(req, name, value));
                }
            }
        } else if (c != null) {
            c.stream().forEach(this::add);
        }
    }

    private RequestFormParams(RequestFormParams copyFrom) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.addAll(copyFrom);
        this.vs = copyFrom.vs;
    }

    private RequestFormParams(RequestFormParams copyFrom, String ... names) {
        this.req = copyFrom.req;
        this.caseSensitive = copyFrom.caseSensitive;
        this.parser = copyFrom.parser;
        this.vs = copyFrom.vs;
        for (String n : names) {
            copyFrom.stream().filter(x -> this.eq(x.getName(), n)).forEach(this::add);
        }
    }

    public RequestFormParams parser(HttpPartParserSession value) {
        this.parser = value;
        this.forEach((? super E x) -> x.parser(this.parser));
        return this;
    }

    public RequestFormParams caseSensitive(boolean value) {
        this.caseSensitive = value;
        return this;
    }

    public RequestFormParams addDefault(List<? extends NameValuePair> pairs) {
        for (NameValuePair nameValuePair : pairs) {
            String name = nameValuePair.getName();
            Stream<RequestFormParam> l = this.stream(name);
            boolean hasAllBlanks = l.allMatch(x -> StringUtils.isEmpty(x.getValue()));
            if (!hasAllBlanks) continue;
            this.removeAll(this.getAll(name));
            this.add(new RequestFormParam(this.req, name, this.vs.resolve(nameValuePair.getValue())));
        }
        return this;
    }

    public RequestFormParams addDefault(NameValuePair ... pairs) {
        return this.addDefault(CollectionUtils.alist(pairs));
    }

    public RequestFormParams addDefault(String name, String value) {
        return this.addDefault(new NameValuePair[]{BasicStringPart.of((String)name, (String)value)});
    }

    public RequestFormParams add(String name, Object value) {
        ArgUtils.assertArgNotNull("name", name);
        this.add(new RequestFormParam(this.req, name, StringUtils.stringify(value)).parser(this.parser));
        return this;
    }

    public RequestFormParams add(NameValuePair ... parameters) {
        ArgUtils.assertArgNotNull("parameters", parameters);
        for (NameValuePair p : parameters) {
            if (p == null) continue;
            this.add(p.getName(), p.getValue());
        }
        return this;
    }

    public RequestFormParams add(Part part) {
        ArgUtils.assertArgNotNull("part", part);
        this.add(new RequestFormParam(this.req, part).parser(this.parser));
        return this;
    }

    public RequestFormParams set(String name, Object value) {
        ArgUtils.assertArgNotNull("name", name);
        this.set(new RequestFormParam(this.req, name, StringUtils.stringify(value)).parser(this.parser));
        return this;
    }

    public RequestFormParams set(NameValuePair ... parameters) {
        ArgUtils.assertArgNotNull("headers", parameters);
        for (NameValuePair p : parameters) {
            this.remove(p);
        }
        for (NameValuePair p : parameters) {
            this.add(p);
        }
        return this;
    }

    public RequestFormParams remove(String name) {
        ArgUtils.assertArgNotNull("name", name);
        this.removeIf(x -> this.eq(x.getName(), name));
        return this;
    }

    public RequestFormParams subset(String ... names) {
        return new RequestFormParams(this, names);
    }

    public boolean contains(String name) {
        return this.stream(name).findAny().isPresent();
    }

    public boolean containsAny(String ... names) {
        ArgUtils.assertArgNotNull("names", names);
        for (String n : names) {
            if (!this.stream(n).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public List<RequestFormParam> getAll(String name) {
        return this.stream(name).collect(Collectors.toList());
    }

    public Stream<RequestFormParam> stream(String name) {
        return this.stream().filter(x -> this.eq(x.getName(), name));
    }

    public Stream<RequestFormParam> getSorted() {
        Comparator<RequestFormParam> x = this.caseSensitive ? Comparator.comparing(RequestHttpPart::getName) : (x1, x2) -> String.CASE_INSENSITIVE_ORDER.compare(x1.getName(), x2.getName());
        return this.stream().sorted(x);
    }

    public List<String> getNames() {
        return this.stream().map(RequestHttpPart::getName).map(x -> this.caseSensitive ? x : x.toLowerCase()).distinct().collect(Collectors.toList());
    }

    public RequestFormParam getFirst(String name) {
        ArgUtils.assertArgNotNull("name", name);
        return this.stream(name).findFirst().orElseGet(() -> new RequestFormParam(this.req, name, null).parser(this.parser));
    }

    public RequestFormParam getLast(String name) {
        ArgUtils.assertArgNotNull("name", name);
        Value<RequestFormParam> v = Value.empty();
        this.stream(name).forEach((? super T x) -> v.set((RequestFormParam)x));
        return v.orElseGet(() -> new RequestFormParam(this.req, name, null).parser(this.parser));
    }

    public RequestFormParam get(String name) {
        List<RequestFormParam> l = this.getAll(name);
        if (l.isEmpty()) {
            return new RequestFormParam(this.req, name, null).parser(this.parser);
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        StringBuilder sb = new StringBuilder(128);
        int j = l.size();
        for (int i = 0; i < j; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(l.get(i).getValue());
        }
        return new RequestFormParam(this.req, name, sb.toString()).parser(this.parser);
    }

    public <T> Optional<T> get(Class<T> type) {
        ClassMeta<T> cm = this.req.getBeanSession().getClassMeta(type);
        String name = (String)HttpParts.getName((HttpPartType)HttpPartType.FORMDATA, cm).orElseThrow(() -> new BasicRuntimeException("@FormData(name) not found on class {0}", ClassUtils.className(type)));
        return this.get(name).as(type);
    }

    public String asQueryString() {
        StringBuilder sb = new StringBuilder();
        for (RequestFormParam e : this) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(StringUtils.urlEncode(e.getName())).append('=').append(StringUtils.urlEncode(e.getValue()));
        }
        return sb.toString();
    }

    public RequestFormParams copy() {
        return new RequestFormParams(this);
    }

    private boolean eq(String s1, String s2) {
        if (this.caseSensitive) {
            return StringUtils.eq(s1, s2);
        }
        return StringUtils.eqic(s1, s2);
    }

    @Override
    public String toString() {
        JsonMap m = new JsonMap();
        for (String n : this.getNames()) {
            m.put(n, (Object)this.get(n).asString().orElse(null));
        }
        return m.asJson();
    }
}

