/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch.cluster.AllocationExplainResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class AllocationExplainRequest
extends RequestBase
implements PlainJsonSerializable {
    @Nullable
    private final String currentNode;
    @Nullable
    private final Boolean includeDiskInfo;
    @Nullable
    private final Boolean includeYesDecisions;
    @Nullable
    private final String index;
    @Nullable
    private final Boolean primary;
    @Nullable
    private final Integer shard;
    public static final JsonpDeserializer<AllocationExplainRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AllocationExplainRequest::setupAllocationExplainRequestDeserializer);
    public static final Endpoint<AllocationExplainRequest, AllocationExplainResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<AllocationExplainRequest, AllocationExplainResponse>(request -> "POST", request -> "/_cluster/allocation/explain", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.includeDiskInfo != null) {
            params.put("include_disk_info", String.valueOf(request.includeDiskInfo));
        }
        if (request.includeYesDecisions != null) {
            params.put("include_yes_decisions", String.valueOf(request.includeYesDecisions));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, AllocationExplainResponse._DESERIALIZER);

    private AllocationExplainRequest(Builder builder) {
        this.currentNode = builder.currentNode;
        this.includeDiskInfo = builder.includeDiskInfo;
        this.includeYesDecisions = builder.includeYesDecisions;
        this.index = builder.index;
        this.primary = builder.primary;
        this.shard = builder.shard;
    }

    public static AllocationExplainRequest of(Function<Builder, ObjectBuilder<AllocationExplainRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String currentNode() {
        return this.currentNode;
    }

    @Nullable
    public final Boolean includeDiskInfo() {
        return this.includeDiskInfo;
    }

    @Nullable
    public final Boolean includeYesDecisions() {
        return this.includeYesDecisions;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nullable
    public final Boolean primary() {
        return this.primary;
    }

    @Nullable
    public final Integer shard() {
        return this.shard;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.currentNode != null) {
            generator.writeKey("current_node");
            generator.write(this.currentNode);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.primary != null) {
            generator.writeKey("primary");
            generator.write(this.primary.booleanValue());
        }
        if (this.shard != null) {
            generator.writeKey("shard");
            generator.write(this.shard.intValue());
        }
    }

    protected static void setupAllocationExplainRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::currentNode, JsonpDeserializer.stringDeserializer(), "current_node");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "index");
        op.add(Builder::primary, JsonpDeserializer.booleanDeserializer(), "primary");
        op.add(Builder::shard, JsonpDeserializer.integerDeserializer(), "shard");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<AllocationExplainRequest> {
        @Nullable
        private String currentNode;
        @Nullable
        private Boolean includeDiskInfo;
        @Nullable
        private Boolean includeYesDecisions;
        @Nullable
        private String index;
        @Nullable
        private Boolean primary;
        @Nullable
        private Integer shard;

        public final Builder currentNode(@Nullable String value) {
            this.currentNode = value;
            return this;
        }

        public final Builder includeDiskInfo(@Nullable Boolean value) {
            this.includeDiskInfo = value;
            return this;
        }

        public final Builder includeYesDecisions(@Nullable Boolean value) {
            this.includeYesDecisions = value;
            return this;
        }

        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        public final Builder primary(@Nullable Boolean value) {
            this.primary = value;
            return this;
        }

        public final Builder shard(@Nullable Integer value) {
            this.shard = value;
            return this;
        }

        @Override
        public AllocationExplainRequest build() {
            this._checkSingleUse();
            return new AllocationExplainRequest(this);
        }
    }
}

