/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.imap.api.ImapConstants;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.LoginRequest;

public class LoginCommandParser
extends AbstractImapCommandParser {
    @Inject
    public LoginCommandParser(StatusResponseFactory statusResponseFactory) {
        super(ImapConstants.LOGIN_COMMAND, statusResponseFactory);
    }

    @Override
    protected ImapMessage decode(ImapRequestLineReader request, Tag tag, ImapSession session) throws DecodingException {
        try {
            Username userid = Username.of((String)request.astring());
            String password = request.astring();
            request.eol();
            return new LoginRequest(userid, password, tag);
        }
        catch (IllegalArgumentException e) {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, e.getMessage(), e);
        }
    }
}

