/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.cassandra.projections;

import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableWithOptions;
import org.apache.james.backends.cassandra.components.CassandraDataDefinition;
import org.apache.james.jmap.cassandra.projections.table.CassandraEmailQueryViewTable;

public interface CassandraEmailQueryViewDataDefinition {
    public static final CassandraDataDefinition MODULE = CassandraDataDefinition.table((String)"email_query_view_sent_at").comment("Storing the JMAP projections for list of emails within a mailbox to not rely on OpenSearch for basic Email/query (sorts sentAt).").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withClusteringOrder(CassandraEmailQueryViewTable.SENT_AT, ClusteringOrder.DESC)).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraEmailQueryViewTable.MAILBOX_ID, DataTypes.UUID).withClusteringColumn(CassandraEmailQueryViewTable.SENT_AT, DataTypes.TIMESTAMP).withClusteringColumn(CassandraEmailQueryViewTable.MESSAGE_ID, DataTypes.UUID)).table("email_query_view_received_at").comment("Storing the JMAP projections for list of emails within a mailbox to not rely on OpenSearch for basic Email/query (sorts and filter on receivedAt).").options(options -> (CreateTableWithOptions)((CreateTableWithOptions)options.withClusteringOrder(CassandraEmailQueryViewTable.RECEIVED_AT, ClusteringOrder.DESC)).withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraEmailQueryViewTable.MAILBOX_ID, DataTypes.UUID).withClusteringColumn(CassandraEmailQueryViewTable.RECEIVED_AT, DataTypes.TIMESTAMP).withClusteringColumn(CassandraEmailQueryViewTable.MESSAGE_ID, DataTypes.UUID).withColumn(CassandraEmailQueryViewTable.SENT_AT, DataTypes.TIMESTAMP)).table("email_query_view_date_lookup").comment("Given a MailboxId+MessageId lookup the dates of a message to delete it.").options(options -> (CreateTableWithOptions)options.withCaching(true, SchemaBuilder.RowsPerPartition.rows((int)10))).statement(statement -> types -> statement.withPartitionKey(CassandraEmailQueryViewTable.MAILBOX_ID, DataTypes.UUID).withClusteringColumn(CassandraEmailQueryViewTable.MESSAGE_ID, DataTypes.UUID).withColumn(CassandraEmailQueryViewTable.SENT_AT, DataTypes.TIMESTAMP).withColumn(CassandraEmailQueryViewTable.RECEIVED_AT, DataTypes.TIMESTAMP)).build();
}

