/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.core.query.lucene.Util;

public class ValueComparator
implements Comparator<Value> {
    @Override
    public int compare(Value a, Value b) {
        try {
            return Util.compare(a, b);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to compare values " + a + " and " + b, e);
        }
    }

    public boolean evaluate(String operator2, Value a, Value b) {
        if ("jcr.operator.equal.to".equals(operator2)) {
            return this.compare(a, b) == 0;
        }
        if ("jcr.operator.greater.than".equals(operator2)) {
            return this.compare(a, b) > 0;
        }
        if ("jcr.operator.greater.than.or.equal.to".equals(operator2)) {
            return this.compare(a, b) >= 0;
        }
        if ("jcr.operator.less.than".equals(operator2)) {
            return this.compare(a, b) < 0;
        }
        if ("jcr.operator.less.than.or.equal.to".equals(operator2)) {
            return this.compare(a, b) <= 0;
        }
        if ("jcr.operator.not.equal.to".equals(operator2)) {
            return this.compare(a, b) != 0;
        }
        if ("jcr.operator.like".equals(operator2)) {
            try {
                Pattern pattern = Util.createRegexp(b.getString());
                return pattern.matcher(a.getString()).matches();
            }
            catch (RepositoryException e) {
                throw new RuntimeException("Unable to compare values " + a + " and " + b, e);
            }
        }
        throw new IllegalArgumentException("Unknown comparison operator: " + operator2);
    }

    @Override
    public int compare(Value[] a, Value[] b) {
        try {
            return Util.compare(a, b);
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Unable to compare values " + Arrays.toString(a) + " and " + Arrays.toString(b), e);
        }
    }

    public boolean evaluate(String operator2, Value[] a, Value[] b) {
        if ("jcr.operator.equal.to".equals(operator2)) {
            return this.compare(a, b) == 0;
        }
        if ("jcr.operator.greater.than".equals(operator2)) {
            return this.compare(a, b) > 0;
        }
        if ("jcr.operator.greater.than.or.equal.to".equals(operator2)) {
            return this.compare(a, b) >= 0;
        }
        if ("jcr.operator.less.than".equals(operator2)) {
            return this.compare(a, b) < 0;
        }
        if ("jcr.operator.less.than.or.equal.to".equals(operator2)) {
            return this.compare(a, b) <= 0;
        }
        if ("jcr.operator.not.equal.to".equals(operator2)) {
            return this.compare(a, b) != 0;
        }
        throw new IllegalArgumentException("Unknown comparison operator: " + operator2);
    }
}

