/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import EDU.oswego.cs.dl.util.concurrent.Latch;
import EDU.oswego.cs.dl.util.concurrent.Mutex;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterContext;
import org.apache.jackrabbit.core.cluster.ClusterException;
import org.apache.jackrabbit.core.cluster.ClusterOperation;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordDeserializer;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.DefaultClusterOperation;
import org.apache.jackrabbit.core.cluster.LockEventChannel;
import org.apache.jackrabbit.core.cluster.LockEventListener;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceEventChannel;
import org.apache.jackrabbit.core.cluster.NamespaceEventListener;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeEventChannel;
import org.apache.jackrabbit.core.cluster.NodeTypeEventListener;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.PrivilegeEventChannel;
import org.apache.jackrabbit.core.cluster.PrivilegeEventListener;
import org.apache.jackrabbit.core.cluster.PrivilegeRecord;
import org.apache.jackrabbit.core.cluster.Update;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.cluster.UpdateEventListener;
import org.apache.jackrabbit.core.cluster.WorkspaceEventChannel;
import org.apache.jackrabbit.core.cluster.WorkspaceListener;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.config.ClusterConfig;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.journal.AbstractJournal;
import org.apache.jackrabbit.core.journal.InstanceRevision;
import org.apache.jackrabbit.core.journal.Journal;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;
import org.apache.jackrabbit.core.journal.RecordConsumer;
import org.apache.jackrabbit.core.journal.RecordProducer;
import org.apache.jackrabbit.core.nodetype.InvalidNodeTypeDefException;
import org.apache.jackrabbit.core.observation.EventState;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.version.InternalVersionManagerImpl;
import org.apache.jackrabbit.core.xml.ClonedInputSource;
import org.apache.jackrabbit.spi.PrivilegeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNode
implements Runnable,
NamespaceEventChannel,
NodeTypeEventChannel,
RecordConsumer,
ClusterRecordProcessor,
WorkspaceEventChannel,
PrivilegeEventChannel {
    public static final String SYSTEM_PROPERTY_NODE_ID = "org.apache.jackrabbit.core.cluster.node_id";
    private static final String PRODUCER_ID = "JR";
    private static final int NONE = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private static Logger auditLogger = LoggerFactory.getLogger("org.apache.jackrabbit.core.audit");
    private static Logger log = LoggerFactory.getLogger(ClusterNode.class);
    private ClusterContext clusterContext;
    private String clusterNodeId;
    private long syncDelay;
    private long stopDelay;
    private Journal journal;
    private Thread syncThread;
    private final Mutex syncLock = new Mutex();
    private final AtomicInteger updateCount = new AtomicInteger();
    private final Latch stopLatch = new Latch();
    private AtomicInteger syncCount = new AtomicInteger();
    private int status;
    private final Map<String, LockEventListener> wspLockListeners = new HashMap<String, LockEventListener>();
    private final Map<String, UpdateEventListener> wspUpdateListeners = new HashMap<String, UpdateEventListener>();
    private UpdateEventListener versionUpdateListener;
    private NamespaceEventListener namespaceListener;
    private WorkspaceListener createWorkspaceListener;
    private NodeTypeEventListener nodeTypeListener;
    private PrivilegeEventListener privilegeListener;
    private InstanceRevision instanceRevision;
    private RecordProducer producer;
    private ClusterRecordDeserializer deserializer = new ClusterRecordDeserializer();
    private boolean disableAutoSync;

    public void init(ClusterContext clusterContext) throws ClusterException {
        this.clusterContext = clusterContext;
        this.init();
    }

    protected void init() throws ClusterException {
        ClusterConfig cc = this.clusterContext.getClusterConfig();
        this.clusterNodeId = cc.getId();
        this.syncDelay = cc.getSyncDelay();
        this.stopDelay = cc.getStopDelay();
        try {
            this.journal = cc.getJournal(this.clusterContext.getNamespaceResolver());
            this.instanceRevision = this.journal.getInstanceRevision();
            this.journal.register(this);
            this.producer = this.journal.getProducer(PRODUCER_ID);
        }
        catch (RepositoryException e) {
            throw new ClusterException("Cluster initialization failed: " + this, e);
        }
        catch (JournalException e) {
            throw new ClusterException("Journal initialization failed: " + this, e);
        }
    }

    public void setStopDelay(long stopDelay) {
        this.stopDelay = stopDelay;
    }

    public long getStopDelay() {
        return this.stopDelay;
    }

    protected void disableAutoSync() {
        this.disableAutoSync = true;
    }

    public synchronized void start() throws ClusterException {
        if (this.status == 0) {
            this.syncOnStartup();
            if (!this.disableAutoSync) {
                Thread t = new Thread((Runnable)this, "ClusterNode-" + this.clusterNodeId);
                t.setDaemon(true);
                t.start();
                this.syncThread = t;
            }
            this.status = 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            String msg;
            try {
                if (this.stopLatch.attempt(this.syncDelay)) {
                    return;
                }
            }
            catch (InterruptedException e) {
                msg = "Interrupted while waiting for stop latch.";
                log.warn(msg);
            }
            try {
                this.sync();
                continue;
            }
            catch (ClusterException e) {
                msg = "Periodic sync of journal failed: " + e.getMessage();
                log.error(msg, e);
                continue;
            }
            catch (Exception e) {
                msg = "Unexpected exception while syncing of journal: " + e.getMessage();
                log.error(msg, e);
                continue;
            }
            catch (Error e) {
                msg = "Unexpected error while syncing of journal: " + e.getMessage();
                log.error(msg, e);
                throw e;
            }
            break;
        }
    }

    private void internalSync(boolean startup) throws ClusterException {
        int count = this.syncCount.get();
        try {
            this.syncLock.acquire();
        }
        catch (InterruptedException e) {
            String msg = "Interrupted while waiting for mutex.";
            throw new ClusterException(msg);
        }
        try {
            if (count == this.syncCount.get()) {
                this.syncCount.incrementAndGet();
                this.journal.sync(startup);
            }
        }
        catch (JournalException e) {
            throw new ClusterException(e.getMessage(), e.getCause());
        }
        finally {
            this.syncLock.release();
        }
    }

    public void sync() throws ClusterException {
        this.internalSync(false);
    }

    public void syncOnStartup() throws ClusterException {
        this.internalSync(true);
    }

    public synchronized void stop() {
        if (this.status != 2) {
            this.status = 2;
            this.stopLatch.release();
            if (this.syncThread != null) {
                try {
                    this.syncThread.join(this.stopDelay);
                }
                catch (InterruptedException e) {
                    String msg = "Interrupted while joining synchronization thread.";
                    log.warn(msg);
                }
            }
            if (this.journal != null) {
                this.journal.close();
            }
            if (this.instanceRevision != null) {
                this.instanceRevision.close();
            }
        }
    }

    public UpdateEventChannel createUpdateChannel(String workspace) {
        return new WorkspaceUpdateChannel(workspace);
    }

    public LockEventChannel createLockChannel(String workspace) {
        return new WorkspaceLockChannel(workspace);
    }

    public Journal getJournal() {
        return this.journal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remapped(String oldPrefix, String newPrefix, String uri) {
        if (this.status != 1) {
            log.info("not started: namespace operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new NamespaceRecord(oldPrefix, newPrefix, uri, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    @Override
    public void setListener(NamespaceEventListener listener) {
        this.namespaceListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registered(Collection ntDefs) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new NodeTypeRecord(ntDefs, true, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reregistered(QNodeTypeDefinition ntDef) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        NodeTypeRecord record = null;
        boolean succeeded = false;
        try {
            record = new NodeTypeRecord(ntDef, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregistered(Collection qnames) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new NodeTypeRecord(qnames, false, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    @Override
    public void setListener(NodeTypeEventListener listener) {
        this.nodeTypeListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registeredPrivileges(Collection<PrivilegeDefinition> definitions) {
        if (this.status != 1) {
            log.info("not started: nodetype operation ignored.");
            return;
        }
        PrivilegeRecord record = null;
        boolean succeeded = false;
        try {
            record = new PrivilegeRecord(definitions, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    @Override
    public void setListener(PrivilegeEventListener listener) {
        this.privilegeListener = listener;
    }

    @Override
    public String getId() {
        return PRODUCER_ID;
    }

    @Override
    public long getRevision() {
        try {
            return this.instanceRevision.get();
        }
        catch (JournalException e) {
            log.warn("Unable to return current revision.", e);
            return Long.MAX_VALUE;
        }
    }

    @Override
    public void consume(Record record) {
        log.info("Processing revision: " + record.getRevision());
        try {
            this.deserializer.deserialize(record).process(this);
        }
        catch (JournalException e) {
            String msg = "Unable to read revision '" + record.getRevision() + "'.";
            log.error(msg, e);
        }
    }

    @Override
    public void setRevision(long revision) {
        try {
            this.instanceRevision.set(revision);
        }
        catch (JournalException e) {
            log.warn("Unable to set current revision to " + revision + ".", e);
        }
    }

    @Override
    public void process(ChangeLogRecord record) {
        block10: {
            String msg;
            String workspace = record.getWorkspace();
            UpdateEventListener listener = null;
            if (workspace != null) {
                listener = this.wspUpdateListeners.get(workspace);
                if (listener == null) {
                    try {
                        this.clusterContext.updateEventsReady(workspace);
                    }
                    catch (RepositoryException e) {
                        msg = "Error making update listener for workspace " + workspace + " online: " + e.getMessage();
                        log.warn(msg);
                    }
                    listener = this.wspUpdateListeners.get(workspace);
                    if (listener == null) {
                        String msg2 = "Update listener unavailable for workspace: " + workspace;
                        log.error(msg2);
                        return;
                    }
                }
            } else if (this.versionUpdateListener != null) {
                listener = this.versionUpdateListener;
            } else {
                String msg3 = "Version update listener unavailable.";
                log.error(msg3);
                return;
            }
            try {
                List<EventState> eventStates = record.getEvents();
                String path = this.getFirstUserId(eventStates) + "@" + workspace + ":" + EventState.getCommonPath(eventStates, null);
                this.updateCount.compareAndSet(Integer.MAX_VALUE, 0);
                auditLogger.info("[{}] {} {}", this.updateCount.incrementAndGet(), record.getRevision(), path);
                listener.externalUpdate(record.getChanges(), eventStates, record.getTimestamp(), record.getUserData());
            }
            catch (RepositoryException e) {
                msg = "Unable to deliver update events: " + e.getMessage();
                log.error(msg);
                if (!(e.getCause() instanceof IllegalStateException)) break block10;
                throw (IllegalStateException)e.getCause();
            }
        }
    }

    @Override
    public void process(LockRecord record) {
        block8: {
            String msg;
            String workspace = record.getWorkspace();
            LockEventListener listener = this.wspLockListeners.get(workspace);
            if (listener == null) {
                try {
                    this.clusterContext.lockEventsReady(workspace);
                }
                catch (RepositoryException e) {
                    msg = "Unable to make lock listener for workspace " + workspace + " online: " + e.getMessage();
                    log.warn(msg);
                }
                listener = this.wspLockListeners.get(workspace);
                if (listener == null) {
                    String msg2 = "Lock channel unavailable for workspace: " + workspace;
                    log.error(msg2);
                    return;
                }
            }
            try {
                if (record.isLock()) {
                    listener.externalLock(record.getNodeId(), record.isDeep(), record.getOwner());
                } else {
                    listener.externalUnlock(record.getNodeId());
                }
            }
            catch (RepositoryException e) {
                msg = "Unable to deliver lock event: " + e.getMessage();
                log.error(msg);
                if (!(e.getCause() instanceof IllegalStateException)) break block8;
                throw (IllegalStateException)e.getCause();
            }
        }
    }

    @Override
    public void process(NamespaceRecord record) {
        if (this.namespaceListener == null) {
            String msg = "Namespace listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            this.namespaceListener.externalRemap(record.getOldPrefix(), record.getNewPrefix(), record.getUri());
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver namespace operation: " + e.getMessage();
            log.error(msg);
        }
    }

    @Override
    public void process(NodeTypeRecord record) {
        if (this.nodeTypeListener == null) {
            String msg = "NodeType listener unavailable.";
            log.error(msg);
            return;
        }
        Collection coll = record.getCollection();
        try {
            switch (record.getOperation()) {
                case 1: {
                    this.nodeTypeListener.externalRegistered(coll);
                    break;
                }
                case 3: {
                    this.nodeTypeListener.externalUnregistered(coll);
                    break;
                }
                case 2: {
                    QNodeTypeDefinition ntd = (QNodeTypeDefinition)coll.iterator().next();
                    this.nodeTypeListener.externalReregistered(ntd);
                }
            }
        }
        catch (InvalidNodeTypeDefException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver node type operation: " + e.getMessage();
            log.error(msg);
        }
    }

    @Override
    public void process(PrivilegeRecord record) {
        if (this.privilegeListener == null) {
            String msg = "Privilege listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            this.privilegeListener.externalRegisteredPrivileges(record.getDefinitions());
        }
        catch (RepositoryException e) {
            String msg = "Unable to deliver privilege registration operation: " + e.getMessage();
            log.error(msg);
        }
    }

    @Override
    public void process(WorkspaceRecord record) {
        if (this.createWorkspaceListener == null) {
            String msg = "Create Workspace listener unavailable.";
            log.error(msg);
            return;
        }
        try {
            if (record.getActionType() == 1) {
                WorkspaceRecord.CreateWorkspaceAction action = record.getCreateWorkspaceAction();
                this.createWorkspaceListener.externalWorkspaceCreated(record.getWorkspace(), action.getInputSource());
            }
        }
        catch (RepositoryException e) {
            String msg = "Unable to create workspace: " + e.getMessage();
            log.error(msg);
        }
    }

    @Override
    public void setListener(WorkspaceListener listener) {
        this.createWorkspaceListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workspaceCreated(String workspaceName, ClonedInputSource inputSource) {
        if (this.status != 1) {
            log.info("not started: namespace operation ignored.");
            return;
        }
        ClusterRecord record = null;
        boolean succeeded = false;
        try {
            record = new WorkspaceRecord(workspaceName, inputSource, this.producer.append());
            record.write();
            record.update();
            this.setRevision(record.getRevision());
            succeeded = true;
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded && record != null) {
                record.cancelUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ended(DefaultClusterOperation operation, boolean successful) {
        ClusterRecord record = operation.getRecord();
        boolean succeeded = false;
        try {
            if (successful) {
                record.write();
                record.update();
                this.setRevision(record.getRevision());
                succeeded = true;
            }
        }
        catch (JournalException e) {
            String msg = "Unable to create log entry: " + e.getMessage();
            log.error(msg);
        }
        catch (Throwable e) {
            String msg = "Unexpected error while creating log entry.";
            log.error(msg, e);
        }
        finally {
            if (!succeeded) {
                record.cancelUpdate();
            }
        }
    }

    private String getFirstUserId(List<EventState> eventStates) {
        if (eventStates == null || eventStates.isEmpty()) {
            return "";
        }
        return eventStates.get(0).getUserId();
    }

    class WorkspaceLockChannel
    implements LockEventChannel {
        private final String workspace;

        public WorkspaceLockChannel(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public ClusterOperation create(NodeId nodeId, boolean deep, String owner) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: lock operation ignored.");
                return null;
            }
            try {
                LockRecord record = new LockRecord(nodeId, deep, owner, ClusterNode.this.producer.append(), this.workspace);
                return new DefaultClusterOperation(ClusterNode.this, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
                return null;
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
                return null;
            }
        }

        @Override
        public ClusterOperation create(NodeId nodeId) {
            if (ClusterNode.this.status != 1) {
                log.info("not started: unlock operation ignored.");
                return null;
            }
            try {
                LockRecord record = new LockRecord(nodeId, ClusterNode.this.producer.append(), this.workspace);
                return new DefaultClusterOperation(ClusterNode.this, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                log.error(msg);
                return null;
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry.";
                log.error(msg, e);
                return null;
            }
        }

        @Override
        public void setListener(LockEventListener listener) {
            ClusterNode.this.wspLockListeners.remove(this.workspace);
            if (listener != null) {
                ClusterNode.this.wspLockListeners.put(this.workspace, listener);
            }
        }
    }

    class WorkspaceUpdateChannel
    implements UpdateEventChannel {
        private static final String ATTRIBUTE_RECORD = "record";
        private static final String ATTRIBUTE_UPDATE_SIZE = "updateSize";
        private final String workspace;

        public WorkspaceUpdateChannel(String workspace) {
            this.workspace = workspace;
        }

        @Override
        public void updateCreated(Update update) throws ClusterException {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update create ignored.");
                return;
            }
            try {
                Record record = ClusterNode.this.producer.append();
                update.setAttribute(ATTRIBUTE_RECORD, record);
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                throw new ClusterException(msg, e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while creating log entry: " + e.getMessage();
                throw new ClusterException(msg, e);
            }
        }

        @Override
        public void updatePrepared(Update update) throws ClusterException {
            if (ClusterNode.this.status != 1) {
                log.info("not started: update prepare ignored.");
                return;
            }
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record == null) {
                String msg = "No record created.";
                log.warn(msg);
                return;
            }
            List<EventState> events = update.getEvents();
            ChangeLog changes = update.getChanges();
            boolean succeeded = false;
            try {
                ChangeLogRecord clr = new ChangeLogRecord(changes, events, record, this.workspace, update.getTimestamp(), update.getUserData());
                clr.write();
                succeeded = true;
            }
            catch (JournalException e) {
                String msg = "Unable to create log entry: " + e.getMessage();
                throw new ClusterException(msg, e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while preparing log entry.";
                throw new ClusterException(msg, e);
            }
            finally {
                if (!succeeded) {
                    record.cancelUpdate();
                    update.setAttribute(ATTRIBUTE_RECORD, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updateCommitted(Update update, String path) {
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record == null) {
                if (ClusterNode.this.status == 1) {
                    log.warn("No record prepared.");
                } else {
                    log.info("not started: update commit ignored.");
                }
                return;
            }
            try {
                long recordRevision = record.getRevision();
                ClusterNode.this.setRevision(recordRevision);
                long journalUpdateSize = record.update();
                log.debug("Stored record '{}' to Journal ({})", (Object)recordRevision, (Object)journalUpdateSize);
                Object updateSizeValue = update.getAttribute(ATTRIBUTE_UPDATE_SIZE);
                long updateSize = updateSizeValue != null ? (Long)updateSizeValue : 0L;
                ClusterNode.this.updateCount.compareAndSet(Integer.MAX_VALUE, 0);
                auditLogger.info("[{}] {} {} ({})", ClusterNode.this.updateCount.incrementAndGet(), record.getRevision(), path, updateSize);
            }
            catch (JournalException e) {
                String msg = "Unable to commit log entry.";
                log.error(msg, e);
            }
            catch (Throwable e) {
                String msg = "Unexpected error while committing log entry.";
                log.error(msg, e);
            }
            finally {
                update.setAttribute(ATTRIBUTE_RECORD, null);
            }
        }

        @Override
        public void updateCancelled(Update update) {
            Record record = (Record)update.getAttribute(ATTRIBUTE_RECORD);
            if (record != null) {
                record.cancelUpdate();
                update.setAttribute(ATTRIBUTE_RECORD, null);
            }
        }

        @Override
        public void setListener(UpdateEventListener listener) {
            if (this.workspace == null) {
                ClusterNode.this.versionUpdateListener = listener;
                if (ClusterNode.this.journal instanceof AbstractJournal && ClusterNode.this.versionUpdateListener instanceof InternalVersionManagerImpl) {
                    ((AbstractJournal)ClusterNode.this.journal).setInternalVersionManager((InternalVersionManagerImpl)ClusterNode.this.versionUpdateListener);
                }
            } else {
                ClusterNode.this.wspUpdateListeners.remove(this.workspace);
                if (listener != null) {
                    ClusterNode.this.wspUpdateListeners.put(this.workspace, listener);
                }
            }
        }
    }
}

