/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.FirstAccumulator;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;

public class FirstDescAccumulator
extends FirstAccumulator {
    public FirstDescAccumulator(TSDataType seriesDataType) {
        super(seriesDataType);
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    protected void addIntInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateIntFirstValue(valueColumn.getInt(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateIntFirstValue(valueColumn.getInt(position), timeColumn.getLong(position));
            }
        }
    }

    @Override
    protected void addLongInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateLongFirstValue(valueColumn.getLong(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateLongFirstValue(valueColumn.getLong(position), timeColumn.getLong(position));
            }
        }
    }

    @Override
    protected void addFloatInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateFloatFirstValue(valueColumn.getFloat(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateFloatFirstValue(valueColumn.getFloat(position), timeColumn.getLong(position));
            }
        }
    }

    @Override
    protected void addDoubleInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateDoubleFirstValue(valueColumn.getDouble(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateDoubleFirstValue(valueColumn.getDouble(position), timeColumn.getLong(position));
            }
        }
    }

    @Override
    protected void addBinaryInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBinaryFirstValue(valueColumn.getBinary(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBinaryFirstValue(valueColumn.getBinary(position), timeColumn.getLong(position));
            }
        }
    }

    @Override
    protected void addBooleanInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBooleanFirstValue(valueColumn.getBoolean(i), timeColumn.getLong(i));
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBooleanFirstValue(valueColumn.getBoolean(position), timeColumn.getLong(position));
            }
        }
    }
}

