/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.sink.payload.thrift.request;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeCompressor;
import org.apache.iotdb.commons.pipe.sink.compressor.PipeCompressorFactory;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.IoTDBSinkRequestVersion;
import org.apache.iotdb.commons.pipe.sink.payload.thrift.request.PipeRequestType;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.PublicBAOS;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PipeTransferCompressedReq
extends TPipeTransferReq {
    public static TPipeTransferReq toTPipeTransferReq(TPipeTransferReq originalReq, List<PipeCompressor> compressors) throws IOException {
        PipeTransferCompressedReq compressedReq = new PipeTransferCompressedReq();
        compressedReq.version = IoTDBSinkRequestVersion.VERSION_1.getVersion();
        compressedReq.type = PipeRequestType.TRANSFER_COMPRESSED.getType();
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            byte[] body = BytesUtils.concatByteArrayList(Arrays.asList({originalReq.version}, BytesUtils.shortToBytes((short)originalReq.type), originalReq.getBody()));
            ReadWriteIOUtils.write((byte)((byte)compressors.size()), (OutputStream)outputStream);
            for (PipeCompressor compressor : compressors) {
                ReadWriteIOUtils.write((byte)compressor.serialize(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((int)body.length, (OutputStream)outputStream);
                body = compressor.compress(body);
            }
            outputStream.write(body);
            compressedReq.body = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        }
        return compressedReq;
    }

    public static TPipeTransferReq fromTPipeTransferReq(TPipeTransferReq transferReq) throws IOException {
        ByteBuffer compressedBuffer = transferReq.body;
        ArrayList<PipeCompressor> compressors = new ArrayList<PipeCompressor>();
        ArrayList<Integer> uncompressedLengths = new ArrayList<Integer>();
        int compressorsSize = ReadWriteIOUtils.readByte((ByteBuffer)compressedBuffer);
        for (int i = 0; i < compressorsSize; ++i) {
            compressors.add(PipeCompressorFactory.getCompressor(ReadWriteIOUtils.readByte((ByteBuffer)compressedBuffer)));
            uncompressedLengths.add(ReadWriteIOUtils.readInt((ByteBuffer)compressedBuffer));
            PipeTransferCompressedReq.checkDecompressedLength((Integer)uncompressedLengths.get(i));
        }
        byte[] body = new byte[compressedBuffer.remaining()];
        compressedBuffer.get(body);
        for (int i = compressors.size() - 1; i >= 0; --i) {
            body = ((PipeCompressor)compressors.get(i)).decompress(body, (Integer)uncompressedLengths.get(i));
        }
        ByteBuffer decompressedBuffer = ByteBuffer.wrap(body);
        TPipeTransferReq decompressedReq = new TPipeTransferReq();
        decompressedReq.version = ReadWriteIOUtils.readByte((ByteBuffer)decompressedBuffer);
        decompressedReq.type = ReadWriteIOUtils.readShort((ByteBuffer)decompressedBuffer);
        decompressedReq.body = decompressedBuffer.slice();
        return decompressedReq;
    }

    private static void checkDecompressedLength(int decompressedLength) throws IllegalArgumentException {
        int maxDecompressedLength = PipeConfig.getInstance().getPipeReceiverReqDecompressedMaxLengthInBytes();
        if (decompressedLength < 0 || decompressedLength > maxDecompressedLength) {
            throw new IllegalArgumentException(String.format("Decompressed length should be between 0 and %d, but got %d.", maxDecompressedLength, decompressedLength));
        }
    }

    public static byte[] toTPipeTransferReqBytes(byte[] rawReqInBytes, List<PipeCompressor> compressors) throws IOException {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            Object object;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                byte[] body = rawReqInBytes;
                ReadWriteIOUtils.write((byte)IoTDBSinkRequestVersion.VERSION_1.getVersion(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((short)PipeRequestType.TRANSFER_COMPRESSED.getType(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((byte)((byte)compressors.size()), (OutputStream)outputStream);
                for (PipeCompressor compressor : compressors) {
                    ReadWriteIOUtils.write((byte)compressor.serialize(), (OutputStream)outputStream);
                    ReadWriteIOUtils.write((int)body.length, (OutputStream)outputStream);
                    body = compressor.compress(body);
                }
                outputStream.write(body);
                object = byteArrayOutputStream.toByteArray();
            }
            return object;
        }
    }

    private PipeTransferCompressedReq() {
    }
}

