/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.write.writer.TsFileOutput;

public class CompactionTsFileOutput
extends OutputStream
implements TsFileOutput {
    private TsFileOutput output;
    private RateLimiter rateLimiter;
    private final int maxSizePerWrite;

    public CompactionTsFileOutput(TsFileOutput output, RateLimiter rateLimiter) {
        this.output = output;
        this.rateLimiter = rateLimiter;
        this.maxSizePerWrite = (int)Math.min((long)rateLimiter.getRate(), Integer.MAX_VALUE);
    }

    @Override
    public void write(int b) throws IOException {
        this.rateLimiter.acquire(1);
        this.output.wrapAsStream().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte b) throws IOException {
        this.rateLimiter.acquire(1);
        this.output.write(b);
    }

    public void write(ByteBuffer b) throws IOException {
        this.write(b.array());
    }

    public long getPosition() throws IOException {
        return this.output.getPosition();
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }

    public OutputStream wrapAsStream() {
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.output.flush();
    }

    public void truncate(long size) throws IOException {
        this.output.truncate(size);
    }

    public void force() throws IOException {
        this.output.force();
    }

    @Override
    public void write(byte[] buf, int start, int length) throws IOException {
        while (length > 0) {
            int writeSize = Math.min(length, this.maxSizePerWrite);
            this.rateLimiter.acquire(writeSize);
            this.output.wrapAsStream().write(buf, start, writeSize);
            start += writeSize;
            length -= writeSize;
        }
    }
}

