/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.task.meta;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMeta;
import org.apache.iotdb.commons.pipe.agent.task.progress.CommitterKey;

public class PipeTemporaryMetaInAgent
implements PipeTemporaryMeta {
    private final AtomicLong floatingMemoryUsageInByte = new AtomicLong(0L);
    private final String pipeNameWithCreationTime;
    private final Map<Integer, CommitterKey> regionId2CommitterKeyMap = new ConcurrentHashMap<Integer, CommitterKey>();

    PipeTemporaryMetaInAgent(String pipeName, long creationTime) {
        this.pipeNameWithCreationTime = pipeName + "_" + creationTime;
    }

    public void addFloatingMemoryUsageInByte(long usage) {
        this.floatingMemoryUsageInByte.addAndGet(usage);
    }

    public void decreaseFloatingMemoryUsageInByte(long usage) {
        this.floatingMemoryUsageInByte.addAndGet(-usage);
    }

    public long getFloatingMemoryUsageInByte() {
        return this.floatingMemoryUsageInByte.get();
    }

    public String getPipeNameWithCreationTime() {
        return this.pipeNameWithCreationTime;
    }

    public CommitterKey getCommitterKey(String pipeName, long creationTime, int regionId, int restartTime) {
        CommitterKey key = this.regionId2CommitterKeyMap.get(regionId);
        if (Objects.nonNull(key) && key.getRestartTimes() == restartTime) {
            return key;
        }
        CommitterKey newKey = new CommitterKey(pipeName, creationTime, regionId, restartTime);
        if (Objects.nonNull(key) && restartTime < key.getRestartTimes()) {
            return newKey;
        }
        this.regionId2CommitterKeyMap.put(regionId, newKey);
        return newKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipeTemporaryMetaInAgent that = (PipeTemporaryMetaInAgent)o;
        return Objects.equals(this.floatingMemoryUsageInByte.get(), that.floatingMemoryUsageInByte.get()) && Objects.equals(this.regionId2CommitterKeyMap, that.regionId2CommitterKeyMap);
    }

    public int hashCode() {
        return Objects.hash(this.floatingMemoryUsageInByte, this.regionId2CommitterKeyMap);
    }

    public String toString() {
        return "PipeTemporaryMeta{floatingMemoryUsage=" + this.floatingMemoryUsageInByte + ", regionId2CommitterKeyMap=" + this.regionId2CommitterKeyMap + '}';
    }
}

