/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.sink.util.builder;

import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.table.column.TsTableColumnCategory;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.pipe.sink.util.builder.PipeTableModelTsFileBuilder;
import org.apache.iotdb.db.pipe.sink.util.builder.PipeTsFileBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.RelationalInsertTabletNode;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.PrimitiveMemTable;
import org.apache.tsfile.enums.ColumnCategory;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.TableSchema;
import org.apache.tsfile.utils.BitMap;
import org.apache.tsfile.utils.DateUtils;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.write.record.Tablet;
import org.apache.tsfile.write.schema.IMeasurementSchema;
import org.apache.tsfile.write.schema.MeasurementSchema;
import org.apache.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeTableModelTsFileBuilderV2
extends PipeTsFileBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeTableModelTsFileBuilderV2.class);
    private static final PlanNodeId PLACEHOLDER_PLAN_NODE_ID = new PlanNodeId("PipeTableModelTsFileBuilderV2");
    private final Map<String, List<Tablet>> dataBase2TabletList = new HashMap<String, List<Tablet>>();
    private final PipeTableModelTsFileBuilder fallbackBuilder;

    public PipeTableModelTsFileBuilderV2(AtomicLong currentBatchId, AtomicLong tsFileIdGenerator) {
        super(currentBatchId, tsFileIdGenerator);
        this.fallbackBuilder = new PipeTableModelTsFileBuilder(currentBatchId, tsFileIdGenerator);
    }

    @Override
    public void bufferTableModelTablet(String dataBase, Tablet tablet) {
        this.dataBase2TabletList.computeIfAbsent(dataBase, db -> new ArrayList()).add(tablet);
    }

    @Override
    public void bufferTreeModelTablet(Tablet tablet, Boolean isAligned) {
        throw new UnsupportedOperationException("PipeTableModeTsFileBuilderV2 does not support tree model tablet to build TSFile");
    }

    @Override
    public List<Pair<String, File>> convertTabletToTsFileWithDBInfo() throws IOException {
        if (this.dataBase2TabletList.isEmpty()) {
            return new ArrayList<Pair<String, File>>(0);
        }
        try {
            ArrayList<Pair<String, File>> pairList = new ArrayList<Pair<String, File>>();
            for (String dataBase : this.dataBase2TabletList.keySet()) {
                pairList.addAll(this.writeTabletsToTsFiles(dataBase));
            }
            return pairList;
        }
        catch (Exception e) {
            LOGGER.warn("Exception occurred when PipeTableModelTsFileBuilderV2 writing tablets to tsfile, use fallback tsfile builder: {}", (Object)e.getMessage(), (Object)e);
            return this.fallbackBuilder.convertTabletToTsFileWithDBInfo();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.dataBase2TabletList.isEmpty();
    }

    @Override
    public synchronized void onSuccess() {
        super.onSuccess();
        this.dataBase2TabletList.clear();
        this.fallbackBuilder.onSuccess();
    }

    @Override
    public synchronized void close() {
        super.close();
        this.dataBase2TabletList.clear();
        this.fallbackBuilder.close();
    }

    private List<Pair<String, File>> writeTabletsToTsFiles(String dataBase) throws org.apache.tsfile.exception.write.WriteProcessException {
        PrimitiveMemTable memTable = new PrimitiveMemTable(null, null);
        ArrayList<Pair<String, File>> sealedFiles = new ArrayList<Pair<String, File>>();
        try (RestorableTsFileIOWriter writer = new RestorableTsFileIOWriter(this.createFile());){
            this.writeTabletsIntoOneFile(dataBase, memTable, writer);
            sealedFiles.add(new Pair((Object)dataBase, (Object)writer.getFile()));
        }
        catch (Exception e) {
            LOGGER.warn("Batch id = {}: Failed to write tablets into tsfile, because {}", new Object[]{this.currentBatchId.get(), e.getMessage(), e});
            throw new org.apache.tsfile.exception.write.WriteProcessException((Throwable)e);
        }
        finally {
            memTable.release();
        }
        return sealedFiles;
    }

    private void writeTabletsIntoOneFile(String dataBase, IMemTable memTable, RestorableTsFileIOWriter writer) throws Exception {
        List<Tablet> tabletList = Objects.requireNonNull(this.dataBase2TabletList.get(dataBase));
        HashMap<String, List> tableName2TabletList = new HashMap<String, List>();
        for (Tablet tablet2 : tabletList) {
            tableName2TabletList.computeIfAbsent(tablet2.getTableName(), k -> new ArrayList()).add(tablet2);
        }
        for (Map.Entry entry : tableName2TabletList.entrySet()) {
            String tableName = (String)entry.getKey();
            List tablets = (List)entry.getValue();
            List aggregatedSchemas = tablets.stream().flatMap(tablet -> tablet.getSchemas().stream()).collect(Collectors.toList());
            List aggregatedColumnCategories = tablets.stream().flatMap(tablet -> tablet.getColumnTypes().stream()).collect(Collectors.toList());
            HashSet seen = new HashSet();
            List distinctIndices = IntStream.range(0, aggregatedSchemas.size()).filter(i -> Objects.nonNull(aggregatedSchemas.get(i))).filter(i -> seen.add((IMeasurementSchema)aggregatedSchemas.get(i))).boxed().collect(Collectors.toList());
            writer.getSchema().getTableSchemaMap().put(tableName, new TableSchema(tableName, distinctIndices.stream().map(aggregatedSchemas::get).collect(Collectors.toList()), distinctIndices.stream().map(aggregatedColumnCategories::get).collect(Collectors.toList())));
        }
        int n = tabletList.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Tablet tablet3 = tabletList.get(i2);
            MeasurementSchema[] measurementSchemas = (MeasurementSchema[])tablet3.getSchemas().stream().map(schema -> (MeasurementSchema)schema).toArray(MeasurementSchema[]::new);
            Object[] values = Arrays.copyOf(tablet3.getValues(), tablet3.getValues().length);
            BitMap[] bitMaps = Arrays.copyOf(tablet3.getBitMaps(), tablet3.getBitMaps().length);
            ColumnCategory[] columnCategory = tablet3.getColumnTypes().toArray(new ColumnCategory[0]);
            int validatedIndex = 0;
            for (int j = 0; j < tablet3.getSchemas().size(); ++j) {
                MeasurementSchema schema2 = measurementSchemas[j];
                if (Objects.isNull(schema2) || Objects.isNull(columnCategory[j])) continue;
                if (Objects.equals(TSDataType.DATE, schema2.getType()) && values[j] instanceof LocalDate[]) {
                    LocalDate[] dates = (LocalDate[])values[j];
                    int[] dateValues = new int[dates.length];
                    for (int k2 = 0; k2 < Math.min(dates.length, tablet3.getRowSize()); ++k2) {
                        if (!Objects.nonNull(dates[k2])) continue;
                        dateValues[k2] = DateUtils.parseDateExpressionToInt((LocalDate)dates[k2]);
                    }
                    values[j] = dateValues;
                }
                measurementSchemas[validatedIndex] = schema2;
                values[validatedIndex] = values[j];
                bitMaps[validatedIndex] = bitMaps[j];
                columnCategory[validatedIndex] = columnCategory[j];
                ++validatedIndex;
            }
            if (validatedIndex != measurementSchemas.length) {
                values = Arrays.copyOf(values, validatedIndex);
                measurementSchemas = Arrays.copyOf(measurementSchemas, validatedIndex);
                bitMaps = Arrays.copyOf(bitMaps, validatedIndex);
                columnCategory = Arrays.copyOf(columnCategory, validatedIndex);
            }
            RelationalInsertTabletNode insertTabletNode = new RelationalInsertTabletNode(PLACEHOLDER_PLAN_NODE_ID, new PartialPath(tablet3.getTableName()), true, (String[])Arrays.stream(measurementSchemas).map(MeasurementSchema::getMeasurementName).toArray(String[]::new), (TSDataType[])Arrays.stream(measurementSchemas).map(MeasurementSchema::getType).toArray(TSDataType[]::new), measurementSchemas, tablet3.getTimestamps(), bitMaps, values, tablet3.getRowSize(), (TsTableColumnCategory[])Arrays.stream(columnCategory).map(TsTableColumnCategory::fromTsFileColumnCategory).toArray(TsTableColumnCategory[]::new));
            boolean start = false;
            int end = insertTabletNode.getRowCount();
            try {
                if (insertTabletNode.isAligned()) {
                    memTable.insertAlignedTablet(insertTabletNode, 0, end, null);
                    continue;
                }
                memTable.insertTablet(insertTabletNode, 0, end);
                continue;
            }
            catch (WriteProcessException e) {
                throw new org.apache.tsfile.exception.write.WriteProcessException((Throwable)((Object)e));
            }
        }
        MemTableFlushTask memTableFlushTask = new MemTableFlushTask(memTable, writer, null, null);
        memTableFlushTask.syncFlushMemTable();
        writer.endFile();
    }
}

