/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public enum SchemaRegionPlanType {
    CREATE_TIMESERIES(4),
    DELETE_TIMESERIES(21),
    CHANGE_TAG_OFFSET(28),
    CHANGE_ALIAS(29),
    AUTO_CREATE_DEVICE_MNODE(40),
    CREATE_ALIGNED_TIMESERIES(41),
    ACTIVATE_TEMPLATE_IN_CLUSTER(63),
    PRE_DELETE_TIMESERIES_IN_CLUSTER(64),
    ROLLBACK_PRE_DELETE_TIMESERIES(65),
    PRE_DEACTIVATE_TEMPLATE(0),
    ROLLBACK_PRE_DEACTIVATE_TEMPLATE(1),
    DEACTIVATE_TEMPLATE(2),
    CREATE_LOGICAL_VIEW(66),
    PRE_DELETE_LOGICAL_VIEW(67),
    ROLLBACK_PRE_DELETE_LOGICAL_VIEW(68),
    DELETE_LOGICAL_VIEW(69),
    ALTER_LOGICAL_VIEW(70),
    CREATE_TABLE_DEVICE(100),
    UPDATE_TABLE_DEVICE_ATTRIBUTE(101),
    COMMIT_UPDATE_TABLE_DEVICE_ATTRIBUTE(102),
    ADD_NODE_LOCATION(103),
    DELETE_TABLE_DEVICE(104),
    CONSTRUCT_TABLE_DEVICES_BLACK_LIST(105),
    ROLLBACK_TABLE_DEVICES_BLACK_LIST(106),
    DELETE_TABLE_DEVICES_IN_BLACK_LIST(107),
    DROP_TABLE_ATTRIBUTE(108),
    READ_SCHEMA(127);

    public static final int MAX_NUM = 128;
    private static final SchemaRegionPlanType[] PLAN_TYPE_TABLE;
    private final byte planType;

    private SchemaRegionPlanType(byte planType) {
        this.planType = planType;
    }

    public byte getPlanType() {
        return this.planType;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(this.planType);
    }

    public static SchemaRegionPlanType deserialize(ByteBuffer buffer) {
        byte code = buffer.get();
        SchemaRegionPlanType type = PLAN_TYPE_TABLE[code];
        if (type == null) {
            throw new IllegalArgumentException("Unrecognized SchemaRegionPlanType of " + code);
        }
        return type;
    }

    static {
        PLAN_TYPE_TABLE = new SchemaRegionPlanType[128];
        SchemaRegionPlanType[] schemaRegionPlanTypeArray = SchemaRegionPlanType.values();
        int n = schemaRegionPlanTypeArray.length;
        for (int i = 0; i < n; ++i) {
            SchemaRegionPlanType type;
            SchemaRegionPlanType.PLAN_TYPE_TABLE[type.planType] = type = schemaRegionPlanTypeArray[i];
        }
    }
}

