/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.persistence.pipe.PipeTaskInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.impl.pipe.AbstractOperatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.pipe.PipeTaskOperation;
import org.apache.iotdb.confignode.procedure.state.pipe.task.OperatePipeTaskState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartPipeProcedureV2
extends AbstractOperatePipeProcedureV2 {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartPipeProcedureV2.class);
    private String pipeName;

    public StartPipeProcedureV2() {
    }

    public StartPipeProcedureV2(String pipeName) throws PipeException {
        this.pipeName = pipeName;
    }

    @Override
    protected PipeTaskOperation getOperation() {
        return PipeTaskOperation.START_PIPE;
    }

    @Override
    public boolean executeFromValidateTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StartPipeProcedureV2: executeFromValidateTask({})", (Object)this.pipeName);
        ((PipeTaskInfo)this.pipeTaskInfo.get()).checkBeforeStartPipe(this.pipeName);
        return !((PipeTaskInfo)this.pipeTaskInfo.get()).isPipeRunning(this.pipeName) || ((PipeTaskInfo)this.pipeTaskInfo.get()).isStoppedByRuntimeException(this.pipeName);
    }

    @Override
    public void executeFromCalculateInfoForTask(ConfigNodeProcedureEnv env) throws PipeException {
        LOGGER.info("StartPipeProcedureV2: executeFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    public void executeFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) throws PipeException {
        TSStatus response;
        LOGGER.info("StartPipeProcedureV2: executeFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        try {
            response = env.getConfigManager().getConsensusManager().write(new SetPipeStatusPlanV2(this.pipeName, PipeStatus.RUNNING));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void executeFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        LOGGER.info("StartPipeProcedureV2: executeFromOperateOnDataNodes({})", (Object)this.pipeName);
        String exceptionMessage = StartPipeProcedureV2.parsePushPipeMetaExceptionForPipe(this.pipeName, this.pushSinglePipeMetaToDataNodes(this.pipeName, env));
        if (!exceptionMessage.isEmpty()) {
            LOGGER.warn("Failed to start pipe {}, details: {}, metadata will be synchronized later.", (Object)this.pipeName, (Object)exceptionMessage);
            return;
        }
        ((PipeTaskInfo)this.pipeTaskInfo.get()).clearExceptionsAndSetIsStoppedByRuntimeExceptionToFalse(this.pipeName);
    }

    @Override
    public void rollbackFromValidateTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("StartPipeProcedureV2: rollbackFromValidateTask({})", (Object)this.pipeName);
    }

    @Override
    public void rollbackFromCalculateInfoForTask(ConfigNodeProcedureEnv env) {
        LOGGER.info("StartPipeProcedureV2: rollbackFromCalculateInfoForTask({})", (Object)this.pipeName);
    }

    @Override
    public void rollbackFromWriteConfigNodeConsensus(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("StartPipeProcedureV2: rollbackFromWriteConfigNodeConsensus({})", (Object)this.pipeName);
        try {
            response = env.getConfigManager().getConsensusManager().write(new SetPipeStatusPlanV2(this.pipeName, PipeStatus.STOPPED));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
    }

    @Override
    public void rollbackFromOperateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        LOGGER.info("StartPipeProcedureV2: rollbackFromOperateOnDataNodes({})", (Object)this.pipeName);
        String exceptionMessage = StartPipeProcedureV2.parsePushPipeMetaExceptionForPipe(this.pipeName, this.pushPipeMetaToDataNodes(env));
        if (!exceptionMessage.isEmpty()) {
            LOGGER.warn("Failed to rollback start pipe {}, details: {}, metadata will be synchronized later.", (Object)this.pipeName, (Object)exceptionMessage);
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.START_PIPE_PROCEDURE_V2.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartPipeProcedureV2 that = (StartPipeProcedureV2)o;
        return this.getProcId() == that.getProcId() && ((OperatePipeTaskState)((Object)this.getCurrentState())).equals(that.getCurrentState()) && this.getCycles() == that.getCycles() && this.pipeName.equals(that.pipeName);
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.pipeName);
    }
}

