/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.grpc.server;

import org.apache.ratis.client.impl.ClientProtoUtils;
import org.apache.ratis.grpc.GrpcUtil;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.proto.grpc.AdminProtocolServiceGrpc;
import org.apache.ratis.protocol.AdminAsynchronousProtocol;
import org.apache.ratis.protocol.GroupInfoRequest;
import org.apache.ratis.protocol.GroupListRequest;
import org.apache.ratis.protocol.GroupManagementRequest;
import org.apache.ratis.protocol.LeaderElectionManagementRequest;
import org.apache.ratis.protocol.SetConfigurationRequest;
import org.apache.ratis.protocol.SnapshotManagementRequest;
import org.apache.ratis.protocol.TransferLeadershipRequest;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcAdminProtocolService
extends AdminProtocolServiceGrpc.AdminProtocolServiceImplBase {
    static final Logger LOG = LoggerFactory.getLogger(GrpcAdminProtocolService.class);
    private final AdminAsynchronousProtocol protocol;

    public GrpcAdminProtocolService(AdminAsynchronousProtocol protocol) {
        this.protocol = protocol;
    }

    public void groupManagement(RaftProtos.GroupManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        GroupManagementRequest request = ClientProtoUtils.toGroupManagementRequest((RaftProtos.GroupManagementRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.groupManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto, t -> LOG.warn("Failed groupManagement: {}, {}", new Object[]{proto.getOpCase(), request, t}));
    }

    public void groupList(RaftProtos.GroupListRequestProto proto, StreamObserver<RaftProtos.GroupListReplyProto> responseObserver) {
        GroupListRequest request = ClientProtoUtils.toGroupListRequest((RaftProtos.GroupListRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupListAsync(request), ClientProtoUtils::toGroupListReplyProto, t -> LOG.warn("Failed to groupList: {}", (Object)request, t));
    }

    public void groupInfo(RaftProtos.GroupInfoRequestProto proto, StreamObserver<RaftProtos.GroupInfoReplyProto> responseObserver) {
        GroupInfoRequest request = ClientProtoUtils.toGroupInfoRequest((RaftProtos.GroupInfoRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.getGroupInfoAsync(request), ClientProtoUtils::toGroupInfoReplyProto, t -> LOG.warn("Failed to groupInfo: {}", (Object)request, t));
    }

    public void setConfiguration(RaftProtos.SetConfigurationRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SetConfigurationRequest request = ClientProtoUtils.toSetConfigurationRequest((RaftProtos.SetConfigurationRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.setConfigurationAsync(request), ClientProtoUtils::toRaftClientReplyProto, t -> LOG.warn("Failed to setConfiguration: {}", (Object)request, t));
    }

    public void transferLeadership(RaftProtos.TransferLeadershipRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        TransferLeadershipRequest request = ClientProtoUtils.toTransferLeadershipRequest((RaftProtos.TransferLeadershipRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.transferLeadershipAsync(request), ClientProtoUtils::toRaftClientReplyProto, t -> LOG.warn("Failed to transferLeadership: {}", (Object)request, t));
    }

    public void snapshotManagement(RaftProtos.SnapshotManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        SnapshotManagementRequest request = ClientProtoUtils.toSnapshotManagementRequest((RaftProtos.SnapshotManagementRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.snapshotManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto, t -> LOG.warn("Failed snapshotManagement: {}, {}", new Object[]{proto.getOpCase(), request, t}));
    }

    public void leaderElectionManagement(RaftProtos.LeaderElectionManagementRequestProto proto, StreamObserver<RaftProtos.RaftClientReplyProto> responseObserver) {
        LeaderElectionManagementRequest request = ClientProtoUtils.toLeaderElectionManagementRequest((RaftProtos.LeaderElectionManagementRequestProto)proto);
        GrpcUtil.asyncCall(responseObserver, () -> this.protocol.leaderElectionManagementAsync(request), ClientProtoUtils::toRaftClientReplyProto, t -> LOG.warn("Failed leaderElectionManagement: {}, {}", new Object[]{proto.getOpCase(), request, t}));
    }
}

