/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.schema.source;

import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.exception.runtime.SchemaExecutionException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.execution.operator.schema.source.ISchemaSource;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeTTLCache;
import org.apache.iotdb.db.schemaengine.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.schemaengine.schemaregion.read.req.SchemaRegionReadPlanFactory;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.info.IDeviceSchemaInfo;
import org.apache.iotdb.db.schemaengine.schemaregion.read.resp.reader.ISchemaReader;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.read.common.block.TsBlockBuilder;
import org.apache.tsfile.utils.Binary;

public class DeviceSchemaSource
implements ISchemaSource<IDeviceSchemaInfo> {
    private final PartialPath pathPattern;
    private final PathPatternTree scope;
    private final boolean isPrefixMatch;
    private final long limit;
    private final long offset;
    private final boolean hasSgCol;
    private final SchemaFilter schemaFilter;

    DeviceSchemaSource(PartialPath pathPattern, boolean isPrefixPath, long limit, long offset, boolean hasSgCol, SchemaFilter schemaFilter, PathPatternTree scope) {
        this.pathPattern = pathPattern;
        this.isPrefixMatch = isPrefixPath;
        this.limit = limit;
        this.offset = offset;
        this.hasSgCol = hasSgCol;
        this.schemaFilter = schemaFilter;
        this.scope = scope;
    }

    @Override
    public ISchemaReader<IDeviceSchemaInfo> getSchemaReader(ISchemaRegion schemaRegion) {
        try {
            return schemaRegion.getDeviceReader(SchemaRegionReadPlanFactory.getShowDevicesPlan(this.pathPattern, this.limit, this.offset, this.isPrefixMatch, this.schemaFilter, this.scope));
        }
        catch (MetadataException e) {
            throw new SchemaExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public List<ColumnHeader> getInfoQueryColumnHeaders() {
        return this.hasSgCol ? ColumnHeaderConstant.showDevicesWithSgColumnHeaders : ColumnHeaderConstant.showDevicesColumnHeaders;
    }

    @Override
    public void transformToTsBlockColumns(IDeviceSchemaInfo device, TsBlockBuilder builder, String database) {
        String ttlStr;
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(device.getFullPath(), TSFileConfig.STRING_CHARSET));
        int templateId = device.getTemplateId();
        long ttl = DataNodeTTLCache.getInstance().getTTLInMS(device.getPartialPath().getNodes());
        String string = ttlStr = ttl == Long.MAX_VALUE ? "INF" : String.valueOf(ttl);
        if (this.hasSgCol) {
            builder.getColumnBuilder(1).writeBinary(new Binary(database, TSFileConfig.STRING_CHARSET));
            builder.getColumnBuilder(2).writeBinary(new Binary(String.valueOf(device.isAligned()), TSFileConfig.STRING_CHARSET));
            if (templateId != -1) {
                builder.getColumnBuilder(3).writeBinary(new Binary(String.valueOf(ClusterTemplateManager.getInstance().getTemplate(templateId).getName()), TSFileConfig.STRING_CHARSET));
            } else {
                builder.getColumnBuilder(3).appendNull();
            }
            builder.getColumnBuilder(4).writeBinary(new Binary(ttlStr, TSFileConfig.STRING_CHARSET));
        } else {
            builder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(device.isAligned()), TSFileConfig.STRING_CHARSET));
            if (templateId != -1) {
                builder.getColumnBuilder(2).writeBinary(new Binary(String.valueOf(ClusterTemplateManager.getInstance().getTemplate(templateId).getName()), TSFileConfig.STRING_CHARSET));
            } else {
                builder.getColumnBuilder(2).appendNull();
            }
            builder.getColumnBuilder(3).writeBinary(new Binary(ttlStr, TSFileConfig.STRING_CHARSET));
        }
        builder.declarePosition();
    }

    @Override
    public boolean hasSchemaStatistic(ISchemaRegion schemaRegion) {
        return (this.pathPattern.equals((Object)SchemaConstant.ALL_MATCH_PATTERN) || this.pathPattern.include(new PartialPath((schemaRegion.getDatabaseFullPath() + ".**").split("\\.")))) && this.schemaFilter == null && this.scope.equals((Object)SchemaConstant.ALL_MATCH_SCOPE);
    }

    @Override
    public long getSchemaStatistic(ISchemaRegion schemaRegion) {
        return schemaRegion.getSchemaRegionStatistics().getDevicesNumber();
    }
}

