/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.tsfile.exception.StopReadTsFileByInterruptException;
import org.apache.tsfile.read.reader.TsFileInput;

public class CompactionTsFileInput
implements TsFileInput {
    private final TsFileInput tsFileInput;

    public CompactionTsFileInput(TsFileInput tsFileInput) {
        this.tsFileInput = tsFileInput;
    }

    public long size() throws IOException {
        try {
            return this.tsFileInput.size();
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new StopReadTsFileByInterruptException();
            }
            throw e;
        }
    }

    public long position() throws IOException {
        try {
            return this.tsFileInput.position();
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new StopReadTsFileByInterruptException();
            }
            throw e;
        }
    }

    public TsFileInput position(long newPosition) throws IOException {
        try {
            return this.tsFileInput.position(newPosition);
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                throw new StopReadTsFileByInterruptException();
            }
            throw e;
        }
    }

    public int read(ByteBuffer dst) throws IOException {
        int readSize = this.tsFileInput.read(dst);
        if (Thread.currentThread().isInterrupted()) {
            throw new StopReadTsFileByInterruptException();
        }
        return readSize;
    }

    public int read(ByteBuffer dst, long position) throws IOException {
        int readSize = this.tsFileInput.read(dst, position);
        if (Thread.currentThread().isInterrupted()) {
            throw new StopReadTsFileByInterruptException();
        }
        return readSize;
    }

    public InputStream wrapAsInputStream() throws IOException {
        return this.tsFileInput.wrapAsInputStream();
    }

    public void close() throws IOException {
        this.tsFileInput.close();
    }

    public String getFilePath() {
        return this.tsFileInput.getFilePath();
    }
}

