/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.server.console.controller;

import javax.annotation.Resource;
import org.apache.seata.common.result.PageResult;
import org.apache.seata.common.result.SingleResult;
import org.apache.seata.server.console.entity.param.GlobalSessionParam;
import org.apache.seata.server.console.entity.vo.GlobalSessionVO;
import org.apache.seata.server.console.service.GlobalSessionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/console/globalSession"})
public class GlobalSessionController {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalSessionController.class);
    @Resource(type=GlobalSessionService.class)
    private GlobalSessionService globalSessionService;

    @GetMapping(value={"query"})
    public PageResult<GlobalSessionVO> query(@ModelAttribute GlobalSessionParam param) {
        return this.globalSessionService.query(param);
    }

    @DeleteMapping(value={"deleteGlobalSession"})
    public SingleResult<Void> deleteGlobalSession(String xid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to delete the global session, xid: {}", (Object)xid);
        }
        return this.globalSessionService.deleteGlobalSession(xid);
    }

    @DeleteMapping(value={"forceDeleteGlobalSession"})
    public SingleResult<Void> forceDeleteGlobalSession(String xid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to force delete the global session, xid: {}", (Object)xid);
        }
        return this.globalSessionService.forceDeleteGlobalSession(xid);
    }

    @PutMapping(value={"stopGlobalSession"})
    public SingleResult<Void> stopGlobalSession(String xid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to stop the global session, xid: {}", (Object)xid);
        }
        return this.globalSessionService.stopGlobalRetry(xid);
    }

    @PutMapping(value={"startGlobalSession"})
    public SingleResult<Void> startGlobalSession(String xid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to start the global session, xid: {}", (Object)xid);
        }
        return this.globalSessionService.startGlobalRetry(xid);
    }

    @PutMapping(value={"sendCommitOrRollback"})
    public SingleResult<Void> sendCommitOrRollback(String xid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to commit or rollback the global session, xid: {}", (Object)xid);
        }
        return this.globalSessionService.sendCommitOrRollback(xid);
    }

    @PutMapping(value={"changeGlobalStatus"})
    public SingleResult<Void> changeGlobalStatus(String xid) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("manual operation to change the global session, xid: {}", (Object)xid);
        }
        return this.globalSessionService.changeGlobalStatus(xid);
    }
}

