/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.stream.bootstrap;

import com.xiaomi.youpin.docean.Ioc;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.apache.ozhera.log.stream.common.util.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiLogStreamBootstrap {
    private static final Logger log = LoggerFactory.getLogger(MiLogStreamBootstrap.class);

    public static void main(String[] args) {
        try {
            StreamUtils.getConfigFromNacos();
            MiLogStreamBootstrap.initializeApplication();
            MiLogStreamBootstrap.startHealthCheckTask();
            MiLogStreamBootstrap.waitForUserInput();
        }
        catch (IOException e) {
            log.error("An error occurred in the main method.", (Throwable)e);
        }
    }

    private static void initializeApplication() {
        OkHttpClient okHttpClient = MiLogStreamBootstrap.getOkHttpClient();
        Ioc.ins().putBean((Object)okHttpClient).init(new String[]{"org.apache.ozhera.log.stream", "com.xiaomi.youpin.docean"});
    }

    private static void startHealthCheckTask() {
        long initDelay = 0L;
        long intervalTime = 2L;
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> log.debug("I am healthy, time: {}", (Object)LocalDateTime.now()), initDelay, intervalTime, TimeUnit.MINUTES);
    }

    private static void waitForUserInput() throws IOException {
        log.info("press Enter to exit.");
        System.in.read();
    }

    private static OkHttpClient getOkHttpClient() {
        return new OkHttpClient().newBuilder().connectTimeout(60L, TimeUnit.SECONDS).readTimeout(300L, TimeUnit.SECONDS).writeTimeout(300L, TimeUnit.SECONDS).connectionPool(new ConnectionPool(50, 5L, TimeUnit.MINUTES)).build();
    }
}

