/*
 * Decompiled with CFR 0.152.
 */
package com.github.pagehelper.dialect.auto;

import com.github.pagehelper.AutoDialect;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.dialect.auto.C3P0AutoDialect;
import com.github.pagehelper.dialect.auto.DataSourceAutoDialect;
import com.github.pagehelper.dialect.auto.DbcpAutoDialect;
import com.github.pagehelper.dialect.auto.DefaultAutoDialect;
import com.github.pagehelper.dialect.auto.DruidAutoDialect;
import com.github.pagehelper.dialect.auto.HikariAutoDialect;
import com.github.pagehelper.dialect.auto.TomcatAutoDialect;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.ibatis.mapping.MappedStatement;

public class DataSourceNegotiationAutoDialect
implements AutoDialect<String> {
    private static final List<DataSourceAutoDialect> AUTO_DIALECTS = new ArrayList<DataSourceAutoDialect>();
    private Map<String, DataSourceAutoDialect> urlMap = new ConcurrentHashMap<String, DataSourceAutoDialect>();

    public static void registerAutoDialect(DataSourceAutoDialect autoDialect) {
        AUTO_DIALECTS.add(autoDialect);
    }

    @Override
    public String extractDialectKey(MappedStatement ms, DataSource dataSource, Properties properties) {
        for (DataSourceAutoDialect autoDialect : AUTO_DIALECTS) {
            String dialectKey = autoDialect.extractDialectKey(ms, dataSource, properties);
            if (dialectKey == null) continue;
            if (!this.urlMap.containsKey(dialectKey)) {
                this.urlMap.put(dialectKey, autoDialect);
            }
            return dialectKey;
        }
        return DefaultAutoDialect.DEFAULT.extractDialectKey(ms, dataSource, properties);
    }

    @Override
    public AbstractHelperDialect extractDialect(String dialectKey, MappedStatement ms, DataSource dataSource, Properties properties) {
        if (this.urlMap.containsKey(dialectKey)) {
            return this.urlMap.get(dialectKey).extractDialect(dialectKey, ms, dataSource, properties);
        }
        return DefaultAutoDialect.DEFAULT.extractDialect(dialectKey, ms, dataSource, properties);
    }

    static {
        try {
            AUTO_DIALECTS.add(new HikariAutoDialect());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AUTO_DIALECTS.add(new DruidAutoDialect());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AUTO_DIALECTS.add(new TomcatAutoDialect());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AUTO_DIALECTS.add(new C3P0AutoDialect());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AUTO_DIALECTS.add(new DbcpAutoDialect());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

