/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.listener;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import com.google.gson.reflect.TypeToken;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.app.api.response.AppBaseInfo;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.enums.ProjectTypeEnum;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.model.bo.AutoAccessLogParam;
import org.apache.ozhera.log.manager.model.bo.LogTailParam;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.service.HeraAppService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionService;
import org.apache.ozhera.log.manager.service.extension.tail.TailExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.impl.LogTailServiceImpl;
import org.apache.ozhera.log.parse.LogParserFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class AutoLogAccessListener {
    private static final Logger log = LoggerFactory.getLogger(AutoLogAccessListener.class);
    @Resource
    private MilogSpaceDao spaceDao;
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogLogTailDao logTailDao;
    @Resource
    private LogTailServiceImpl logTailService;
    private TailExtensionService tailExtensionService;
    @Resource
    private HeraAppService heraAppService;
    @Value(value="$defaultNacosAddres")
    private String nacosAddress;
    private final String ACCESS_LOG_DATA_ID_KEY = "auto_access_log_key";
    private ConfigService configService;

    public void init() throws NacosException {
        this.freshAccessLogList();
    }

    private void freshAccessLogList() throws NacosException {
        if (null == this.configService) {
            this.tailExtensionService = TailExtensionServiceFactory.getTailExtensionService();
            this.configService = this.initConfigService();
            this.startListening();
        }
    }

    private ConfigService initConfigService() throws NacosException {
        Properties properties = new Properties();
        properties.setProperty("serverAddr", this.nacosAddress);
        return NacosFactory.createConfigService((Properties)properties);
    }

    private void startListening() throws NacosException {
        this.configService.addListener("auto_access_log_key", "DEFAULT_GROUP", new Listener(){

            public void receiveConfigInfo(String configInfo) {
                AutoLogAccessListener.this.autoLogAccess(configInfo);
            }

            public Executor getExecutor() {
                return null;
            }
        });
    }

    private void autoLogAccess(String dataContent) {
        List accessLogParamList;
        if (StringUtils.isNotEmpty((CharSequence)dataContent) && CollectionUtils.isNotEmpty((Collection)(accessLogParamList = (List)Constant.GSON.fromJson(dataContent, new TypeToken<List<AutoAccessLogParam>>(this){}.getType())))) {
            accessLogParamList.forEach(this::processLogParam);
        }
    }

    private void processLogParam(AutoAccessLogParam logParam) {
        if (!this.isValidLogParam(logParam)) {
            log.warn("AutoLogAccess, data param valid error, data:{}", (Object)Constant.GSON.toJson((Object)logParam));
            return;
        }
        if (!this.isValidSpace(logParam.getSpaceId())) {
            log.warn("AutoLogAccess, space not exist:{}", (Object)logParam.getSpaceId());
            return;
        }
        MilogLogStoreDO logStoreDO = this.logStoreDao.queryById(logParam.getStoreId());
        if (logStoreDO == null) {
            log.warn("AutoLogAccess, store not exist:{}", (Object)logParam.getStoreId());
            return;
        }
        AppBaseInfo appBaseInfo = this.heraAppService.queryByAppId(logParam.getAppId(), ProjectTypeEnum.MIONE_TYPE.getCode());
        if (appBaseInfo == null) {
            log.warn("AppBaseInfo not exist, appId:{}, appName:{}", (Object)logParam.getAppId(), (Object)logParam.getAppName());
            appBaseInfo = AutoLogAccessListener.buildAppBaseInfo(logParam);
        }
        String tailName = this.generateTailName(logParam.getAppName(), logParam.getEnvName(), logParam.getEnvId());
        if (!this.logTailExists(logParam, (long)appBaseInfo.getId(), tailName)) {
            this.addLogTail(logParam, logStoreDO, appBaseInfo, tailName);
        } else {
            log.info("AutoLogAccess, tail already exist, tailName:{}", (Object)tailName);
        }
    }

    @NotNull
    private static AppBaseInfo buildAppBaseInfo(AutoAccessLogParam logParam) {
        AppBaseInfo appBaseInfo = new AppBaseInfo();
        appBaseInfo.setId(Integer.valueOf((int)(logParam.getAppId() * 100L)));
        appBaseInfo.setAppName(logParam.getAppName());
        appBaseInfo.setBindId(logParam.getAppId().toString());
        return appBaseInfo;
    }

    private boolean isValidLogParam(AutoAccessLogParam logParam) {
        return logParam.getSpaceId() != null && logParam.getAppId() != null && logParam.getStoreId() != null && logParam.getLogPath() != null && logParam.getEnvId() != null && CollectionUtils.isNotEmpty(logParam.getIps());
    }

    private boolean isValidSpace(Long spaceId) {
        return this.spaceDao.queryById(spaceId) != null;
    }

    private boolean logTailExists(AutoAccessLogParam logParam, Long heraAppId, String tailName) {
        List<MilogLogTailDo> logTailDos = this.logTailDao.queryByCondition(logParam.getSpaceId(), logParam.getStoreId(), tailName, heraAppId, logParam.getEnvId(), logParam.getLogPath());
        return CollectionUtils.isNotEmpty(logTailDos);
    }

    private void addLogTail(AutoAccessLogParam logParam, MilogLogStoreDO logStoreDO, AppBaseInfo appBaseInfo, String tailName) {
        LogTailParam logTailParam = this.buildLogTailParam(logParam.getSpaceId(), logStoreDO, logParam, appBaseInfo, tailName, logParam.getIps());
        MilogLogTailDo logTailDo = this.logTailService.buildLogTailDo(logTailParam, logStoreDO, appBaseInfo, "system");
        this.logTailDao.add(logTailDo);
        String topicName = this.buildTopicName(logParam, logTailDo.getTail());
        this.tailExtensionService.defaultBindingAppTailConfigRel(logTailDo.getId(), logTailDo.getMilogAppId(), logStoreDO.getMqResourceId(), topicName, null);
        this.logTailService.sengMessageToStream(logTailDo, OperateEnum.ADD_OPERATE.getCode());
        CompletableFuture.runAsync(() -> this.logTailService.sengMessageToAgent((long)appBaseInfo.getId(), logTailDo));
    }

    private String buildTopicName(AutoAccessLogParam logParam, String tailName) {
        return String.format("%s-%s", logParam.getAppId(), tailName);
    }

    private String generateTailName(String appName, String envName, Long envId) {
        return String.format("%s-%s-%s", appName, envName, envId);
    }

    private LogTailParam buildLogTailParam(Long spaceId, MilogLogStoreDO logStoreDO, AutoAccessLogParam logParam, AppBaseInfo appBaseInfo, String tailName, List<String> ips) {
        return LogTailParam.builder().spaceId(spaceId).storeId(logStoreDO.getId()).appId(logParam.getAppId()).milogAppId((long)appBaseInfo.getId()).envId(logParam.getEnvId()).envName(logParam.getEnvName()).tail(tailName).parseType(LogParserFactory.LogParserEnum.SEPARATOR_PARSE.getCode()).parseScript("|").logPath(logParam.getLogPath()).ips(ips).valueList("0,1,2,3,4,-1,-1,7,6,5").appType(ProjectTypeEnum.MIONE_TYPE.getCode()).deployWay(ProjectTypeEnum.MIONE_TYPE.getCode()).build();
    }
}

