/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import com.google.common.collect.Lists;
import com.xiaomi.mone.tpc.common.vo.NodeVo;
import com.xiaomi.mone.tpc.common.vo.PageDataVo;
import com.xiaomi.youpin.docean.anno.Service;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.api.enums.FavouriteSearchEnum;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.dao.MilogSpaceDao;
import org.apache.ozhera.log.manager.dao.MilogStoreSpaceAuthDao;
import org.apache.ozhera.log.manager.domain.Store;
import org.apache.ozhera.log.manager.mapper.MilogLogSearchSaveMapper;
import org.apache.ozhera.log.manager.model.convert.MilogSpaceConvert;
import org.apache.ozhera.log.manager.model.convert.SearchSaveConvert;
import org.apache.ozhera.log.manager.model.dto.MilogSpaceDTO;
import org.apache.ozhera.log.manager.model.dto.SearchSaveDTO;
import org.apache.ozhera.log.manager.model.dto.SpaceTreeFavouriteDTO;
import org.apache.ozhera.log.manager.model.dto.StoreTreeDTO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogSearchSaveDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogSpaceDO;
import org.apache.ozhera.log.manager.model.vo.KeywordPageParam;
import org.apache.ozhera.log.manager.model.vo.SearchSaveInsertCmd;
import org.apache.ozhera.log.manager.model.vo.SearchSaveUpdateCmd;
import org.apache.ozhera.log.manager.service.IMilogLogSearchSaveService;
import org.apache.ozhera.log.manager.service.impl.TpcSpaceAuthService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class MilogLogSearchSaveServiceImpl
implements IMilogLogSearchSaveService {
    private static final Logger log = LoggerFactory.getLogger(MilogLogSearchSaveServiceImpl.class);
    @Resource
    private MilogLogSearchSaveMapper logSearchSaveMapper;
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private MilogSpaceDao logSpaceDao;
    @Resource
    private MilogStoreSpaceAuthDao storeSpaceAuthDao;
    @Resource
    private MilogLogSearchSaveMapper searchSaveMapper;
    @Resource
    private TpcSpaceAuthService spaceAuthService;
    @Resource
    private Store store;

    public Result<List<SearchSaveDTO>> list(Long storeId, Integer sort) {
        List<SearchSaveDTO> list = this.logSearchSaveMapper.selectByCreator(MoneUserContext.getCurrentUser().getUser(), sort);
        List<Object> result = new ArrayList();
        for (SearchSaveDTO searchSaveDTO2 : list) {
            Long storeIdInner = searchSaveDTO2.getStoreId();
            MilogLogStoreDO logStoreDO = this.logStoreDao.queryById(storeIdInner);
            if (null == logStoreDO) continue;
            searchSaveDTO2.setSpaceId(logStoreDO.getSpaceId());
            MilogSpaceDO spaceDO = this.logSpaceDao.queryById(logStoreDO.getSpaceId());
            searchSaveDTO2.setSpaceName(spaceDO.getSpaceName());
            result.add(searchSaveDTO2);
        }
        if (storeId != null) {
            result = result.stream().filter(searchSaveDTO -> Objects.equals(storeId, searchSaveDTO.getStoreId())).collect(Collectors.toList());
        }
        return Result.success(result);
    }

    public SearchSaveDTO getById(Long id) {
        return SearchSaveConvert.INSTANCE.fromDO((MilogLogSearchSaveDO)this.logSearchSaveMapper.selectById(id));
    }

    public Result<Integer> save(SearchSaveInsertCmd cmd) {
        if (cmd.getSort() == null) {
            return Result.failParam((String)"The classification field sort cannot be empty");
        }
        switch (FavouriteSearchEnum.queryByCode((Integer)cmd.getSort())) {
            case TEXT: {
                if (!this.isRepeatName(cmd.getName())) break;
                return Result.failParam((String)"Names cannot be duplicated");
            }
            case STORE: {
                Integer isMyFavouriteStore = this.logSearchSaveMapper.isMyFavouriteStore(MoneUserContext.getCurrentUser().getUser(), cmd.getStoreId());
                if (isMyFavouriteStore >= 1) {
                    return Result.failParam((String)"Bookmarked");
                }
            }
            case TAIL: {
                Integer isMyFavouriteTail = this.logSearchSaveMapper.isMyFavouriteTail(MoneUserContext.getCurrentUser().getUser(), cmd.getTailId());
                if (isMyFavouriteTail < 1) break;
                return Result.failParam((String)"Bookmarked");
            }
        }
        MilogLogSearchSaveDO logSearchSaveDO = SearchSaveConvert.INSTANCE.toDO(cmd);
        long current = System.currentTimeMillis();
        logSearchSaveDO.setCreateTime(current);
        logSearchSaveDO.setUpdateTime(current);
        String user = MoneUserContext.getCurrentUser().getUser();
        logSearchSaveDO.setCreator(user);
        logSearchSaveDO.setUpdater(user);
        Integer maxOrder = this.logSearchSaveMapper.getMaxOrder(user, cmd.getSort());
        logSearchSaveDO.setOrderNum(maxOrder == null ? 100 : maxOrder + 100);
        int insert = this.logSearchSaveMapper.insert(logSearchSaveDO);
        return Result.success((Object)insert);
    }

    public Result<Integer> update(SearchSaveUpdateCmd cmd) {
        MilogLogSearchSaveDO milogLogSearchSaveDO = (MilogLogSearchSaveDO)this.logSearchSaveMapper.selectById(cmd.getId());
        if (milogLogSearchSaveDO == null) {
            return Result.failParam((String)"Data not found");
        }
        if (!cmd.getName().equals(milogLogSearchSaveDO.getName()) && this.isRepeatName(cmd.getName())) {
            return Result.failParam((String)"Names cannot be duplicated");
        }
        milogLogSearchSaveDO.setName(cmd.getName());
        milogLogSearchSaveDO.setQueryText(cmd.getQueryText());
        milogLogSearchSaveDO.setIsFixTime(cmd.getIsFixTime());
        milogLogSearchSaveDO.setStartTime(cmd.getStartTime());
        milogLogSearchSaveDO.setEndTime(cmd.getEndTime());
        milogLogSearchSaveDO.setCommon(cmd.getCommon());
        milogLogSearchSaveDO.setUpdateTime(System.currentTimeMillis());
        milogLogSearchSaveDO.setUpdater(MoneUserContext.getCurrentUser().getUser());
        int i = this.logSearchSaveMapper.updateById(milogLogSearchSaveDO);
        return Result.success((Object)i);
    }

    public Result<Integer> removeById(Long id) {
        int i = this.logSearchSaveMapper.removeById(id);
        return Result.success((Object)i);
    }

    private boolean isRepeatName(String name) {
        Long count = this.logSearchSaveMapper.countByStoreAndName(name, MoneUserContext.getCurrentUser().getUser());
        return count >= 1L;
    }

    public Result<Boolean> swapOrder(Long idFrom, Long idTo) {
        MilogLogSearchSaveDO from = (MilogLogSearchSaveDO)this.logSearchSaveMapper.selectById(idFrom);
        MilogLogSearchSaveDO to = (MilogLogSearchSaveDO)this.logSearchSaveMapper.selectById(idTo);
        int t = from.getOrderNum();
        from.setOrderNum(to.getOrderNum());
        to.setOrderNum(t);
        int fromRes = this.logSearchSaveMapper.updateById(from);
        int toRes = this.logSearchSaveMapper.updateById(to);
        return Result.success((Object)(fromRes + toRes == 2 ? 1 : 0));
    }

    public Result<Integer> deFavourite(Integer sort, Long id) {
        if (sort == null || id == null) {
            Result.failParam((String)"The parameter cannot be empty");
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        switch (FavouriteSearchEnum.queryByCode((Integer)sort)) {
            case STORE: {
                paramMap.put("store_id", id);
                break;
            }
            case TAIL: {
                paramMap.put("tail_id", id);
                break;
            }
            default: {
                return Result.failParam((String)"Invalid sort field");
            }
        }
        paramMap.put("creator", MoneUserContext.getCurrentUser().getUser());
        paramMap.put("sort", sort);
        int res = this.logSearchSaveMapper.deleteByMap(paramMap);
        return res == 1 ? Result.success() : Result.fail((CommonError)CommonError.ParamsError);
    }

    public Result<List<SpaceTreeFavouriteDTO>> storeTree(KeywordPageParam keywordPageParam) {
        List<SearchSaveDTO> favouriteList;
        CopyOnWriteArrayList dtoList = new CopyOnWriteArrayList();
        ArrayList<MilogSpaceDTO> spaceDTOList = new ArrayList<MilogSpaceDTO>();
        com.xiaomi.youpin.infra.rpc.Result<PageDataVo<NodeVo>> userPermSpace = this.spaceAuthService.getUserPermSpace(keywordPageParam.getKeyword(), keywordPageParam.getPageNum(), keywordPageParam.getPageSize());
        if (userPermSpace.getCode() != 0) {
            return Result.fail((CommonError)CommonError.UNAUTHORIZED);
        }
        if (CollectionUtils.isEmpty((Collection)((PageDataVo)userPermSpace.getData()).getList())) {
            return Result.success(dtoList);
        }
        List<MilogSpaceDTO> spaceDTOListPage = MilogSpaceConvert.INSTANCE.fromTpcPage((PageDataVo<NodeVo>)((PageDataVo)userPermSpace.getData())).getList();
        spaceDTOList.addAll(spaceDTOListPage);
        if (CollectionUtils.isEmpty(spaceDTOList)) {
            return Result.success(dtoList);
        }
        List<Long> spaceIdList = spaceDTOList.stream().map(MilogSpaceDTO::getId).collect(Collectors.toList());
        List<MilogLogStoreDO> storeList = this.store.getStoreList(spaceIdList, keywordPageParam.getKeyword());
        HashMap<Long, ArrayList> spaceStoreMap = new HashMap<Long, ArrayList>();
        if (storeList != null && !storeList.isEmpty()) {
            for (MilogLogStoreDO store : storeList) {
                if (spaceStoreMap.containsKey(store.getSpaceId())) {
                    ((List)spaceStoreMap.get(store.getSpaceId())).add(store);
                    continue;
                }
                spaceStoreMap.put(store.getSpaceId(), Lists.newArrayList((Object[])new MilogLogStoreDO[]{store}));
            }
        }
        Set<Object> favouriteStoreIdSet = (favouriteList = this.searchSaveMapper.selectByCreator(MoneUserContext.getCurrentUser().getUser(), FavouriteSearchEnum.STORE.getCode())) != null && !favouriteList.isEmpty() ? favouriteList.stream().map(SearchSaveDTO::getStoreId).collect(Collectors.toSet()) : new HashSet();
        spaceDTOList.parallelStream().forEach(space -> {
            SpaceTreeFavouriteDTO dto = new SpaceTreeFavouriteDTO();
            dto.setValue(space.getId());
            dto.setLabel(space.getSpaceName());
            ArrayList<StoreTreeDTO> children = new ArrayList<StoreTreeDTO>();
            List storeFerryList = (List)spaceStoreMap.get(space.getId());
            if (storeFerryList != null && !storeFerryList.isEmpty()) {
                for (MilogLogStoreDO storeDO : storeFerryList) {
                    children.add(StoreTreeDTO.Of(storeDO.getId(), storeDO.getLogstoreName(), favouriteStoreIdSet.contains(storeDO.getId()) ? 1 : 0));
                }
            }
            dto.setChildren(children);
            dtoList.add(dto);
        });
        return Result.success(dtoList);
    }

    public Result<Integer> initOrder(String key) {
        if (!"384384".equals(key)) {
            return null;
        }
        List<MilogLogSearchSaveDO> saveList = this.logSearchSaveMapper.getAll();
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        if (saveList != null && !saveList.isEmpty()) {
            log.info("save List size is #{}", (Object)saveList.size());
            for (MilogLogSearchSaveDO save : saveList) {
                if (orderMap.containsKey(save.getCreator())) {
                    Integer order = (Integer)orderMap.get(save.getCreator());
                    save.setOrderNum(order + 100);
                    orderMap.put(save.getCreator(), order + 100);
                } else {
                    save.setOrderNum(100);
                    orderMap.put(save.getCreator(), 100);
                }
                this.logSearchSaveMapper.updateById(save);
            }
        }
        return null;
    }
}

