/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.DoceanConfig;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.es.antlr4.common.util.EsQueryUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.log.manager.dao.MilogLogTailDao;
import org.apache.ozhera.log.manager.domain.Down;
import org.apache.ozhera.log.manager.model.pojo.MilogLogTailDo;
import org.apache.ozhera.log.manager.model.vo.LogContextQuery;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionService;
import org.apache.ozhera.log.manager.service.extension.common.CommonExtensionServiceFactory;
import org.apache.ozhera.log.manager.service.extension.common.DefaultCommonExtensionService;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class SearchLog {
    private static final Logger log = LoggerFactory.getLogger(SearchLog.class);
    @Resource
    private MilogLogTailDao tailDao;
    private CommonExtensionService commonExtensionService;

    public void init() {
        this.commonExtensionService = CommonExtensionServiceFactory.getCommonExtensionService();
    }

    public BoolQueryBuilder getQueryBuilder(LogQuery logQuery, List<String> keyList) {
        this.processTailNamesToIds(logQuery);
        BoolQueryBuilder boolQueryBuilder = this.buildCommonBuilder(logQuery);
        if (StringUtils.isEmpty((String)logQuery.getFullTextSearch())) {
            return boolQueryBuilder;
        }
        SearchSourceBuilder searchSourceBuilder = EsQueryUtils.getSearchSourceBuilder((String)logQuery.getFullTextSearch());
        if (searchSourceBuilder != null) {
            boolQueryBuilder.filter(searchSourceBuilder.query());
        }
        return boolQueryBuilder;
    }

    private BoolQueryBuilder buildCommonBuilder(LogQuery logQuery) {
        BoolQueryBuilder boolQueryBuilder = this.commonExtensionService.commonRangeQuery(logQuery);
        BoolQueryBuilder tailQueryBuilder = QueryBuilders.boolQuery();
        if (CollectionUtils.isNotEmpty(logQuery.getTailIds())) {
            for (Long tailId : logQuery.getTailIds()) {
                tailQueryBuilder.should((QueryBuilder)this.commonExtensionService.multipleChooseBuilder(DefaultCommonExtensionService.QueryTypeEnum.ID, logQuery.getStoreId(), tailId.toString()));
            }
        } else if (StringUtils.isNotEmpty((String)logQuery.getTail())) {
            String[] tailLimitArray;
            for (String tail : tailLimitArray = logQuery.getTail().split(",")) {
                tailQueryBuilder.should((QueryBuilder)this.commonExtensionService.multipleChooseBuilder(DefaultCommonExtensionService.QueryTypeEnum.TEXT, logQuery.getStoreId(), tail));
            }
        }
        tailQueryBuilder.minimumShouldMatch(1);
        boolQueryBuilder.filter((QueryBuilder)tailQueryBuilder);
        return boolQueryBuilder;
    }

    public BoolQueryBuilder getMatrixQueryBuilder(LogQuery logQuery, List<String> keyList) throws Exception {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        Instant fromStartUnixTimestamp = Instant.ofEpochMilli(logQuery.getStartTime());
        String startTime = fromStartUnixTimestamp.atZone(ZoneId.of("+08:00")).toString();
        Instant fromEndUnixTimestamp = Instant.ofEpochMilli(logQuery.getEndTime());
        String endTime = fromEndUnixTimestamp.atZone(ZoneId.of("+08:00")).toString();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"alpha_timestamp").from((Object)startTime).to((Object)endTime));
        if (StringUtils.isEmpty((String)logQuery.getFullTextSearch())) {
            return boolQueryBuilder;
        }
        SearchSourceBuilder searchSourceBuilder = EsQueryUtils.getSearchSourceBuilder((String)logQuery.getFullTextSearch());
        if (searchSourceBuilder != null) {
            boolQueryBuilder.filter(searchSourceBuilder.query());
        }
        return boolQueryBuilder;
    }

    public static BoolQueryBuilder buildTextQuery(String querytext, List<String> keyList) {
        ArrayList<String> mustQueryTextList = new ArrayList<String>();
        ArrayList<String> mustNotQueryTextList = new ArrayList<String>();
        SearchLog.queryAnalyse(querytext, mustQueryTextList, mustNotQueryTextList);
        BoolQueryBuilder boolQueryBuilder = SearchLog.queryDispatchAndBuild(mustQueryTextList, mustNotQueryTextList, keyList);
        return boolQueryBuilder;
    }

    private static BoolQueryBuilder queryDispatchAndBuild(List<String> mustQueryTextList, List<String> mustNotQueryTextList, List<String> keyList) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        for (int i = 0; i < mustQueryTextList.size() + mustNotQueryTextList.size(); ++i) {
            QueryBuilder thisQueryBuilder;
            boolean isGrantQuery = i < mustQueryTextList.size();
            String queryText = isGrantQuery ? mustQueryTextList.get(i) : mustNotQueryTextList.get(i - mustQueryTextList.size());
            if (queryText.startsWith("\"")) {
                queryText = queryText.substring(1, queryText.length() - 1);
                thisQueryBuilder = SearchLog.precisionQueryBuilder(queryText);
                queryBuilder = isGrantQuery ? queryBuilder.must(thisQueryBuilder) : queryBuilder.mustNot(thisQueryBuilder);
                continue;
            }
            if (queryText.contains(":")) {
                String value;
                int kvApartIndex = queryText.indexOf(":");
                String key = queryText.substring(0, kvApartIndex).trim();
                String string = value = kvApartIndex == queryText.length() ? "" : queryText.substring(kvApartIndex + 1).trim();
                if (value.startsWith("\"") && value.endsWith("\"")) {
                    value = value.substring(1, value.length() - 1);
                    thisQueryBuilder = SearchLog.kvPrecisionQueryBuilder(key, value);
                    queryBuilder = isGrantQuery ? queryBuilder.must(thisQueryBuilder) : queryBuilder.mustNot(thisQueryBuilder);
                    continue;
                }
                thisQueryBuilder = SearchLog.kvMatchQueryBuilder(key, value);
                queryBuilder = isGrantQuery ? queryBuilder.must(thisQueryBuilder) : queryBuilder.mustNot(thisQueryBuilder);
                continue;
            }
            thisQueryBuilder = SearchLog.multiMatchQueryBuilder(queryText, keyList);
            queryBuilder = isGrantQuery ? queryBuilder.must(thisQueryBuilder) : queryBuilder.mustNot(thisQueryBuilder);
        }
        return queryBuilder;
    }

    private static void queryAnalyse(String querytext, List<String> mustQueryTextList, List<String> mustNotQueryTextList) {
        do {
            querytext = querytext.trim();
            boolean isGrantQuery = true;
            if (isGrantQuery && querytext.trim().toLowerCase().startsWith("not ")) {
                isGrantQuery = false;
                querytext = querytext.substring(4);
            }
            int endIndex = SearchLog.getEndIndex(querytext);
            String thisQuerytext = querytext.substring(0, endIndex);
            if (isGrantQuery) {
                mustQueryTextList.add(thisQuerytext);
            } else {
                mustNotQueryTextList.add(thisQuerytext);
            }
            querytext = querytext.substring(endIndex).trim();
            if (!querytext.toLowerCase().startsWith("and ")) continue;
            querytext = querytext.substring(4);
        } while (StringUtils.isNotEmpty((String)querytext));
    }

    private static QueryBuilder kvMatchQueryBuilder(String key, String value) {
        key = key.trim();
        value = value.trim();
        if ("logLevel".equals(key) || "level".equals(key) && ("INFO".equalsIgnoreCase(value) || "WARN".equalsIgnoreCase(value))) {
            value = String.format("%-5s", value);
        }
        return QueryBuilders.matchQuery((String)key, (Object)value);
    }

    private static QueryBuilder multiMatchQueryBuilder(String querytext, List<String> keyList) {
        BoolQueryBuilder textQueryBuilder = QueryBuilders.boolQuery();
        textQueryBuilder.should(SearchLog.regexpQuery(querytext));
        QueryBuilder queryBuilder = QueryBuildChain.doChain(querytext, keyList);
        textQueryBuilder.should(queryBuilder);
        textQueryBuilder.minimumShouldMatch(1);
        return textQueryBuilder;
    }

    private static QueryBuilder regexpQuery(String querytext) {
        return QueryBuilders.regexpQuery((String)"message", (String)querytext.toLowerCase());
    }

    private static QueryBuilder precisionQueryBuilder(String querytext) {
        BoolQueryBuilder phraseQueryBuilder = QueryBuilders.boolQuery();
        phraseQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"message", (Object)querytext));
        phraseQueryBuilder.should((QueryBuilder)QueryBuilders.termQuery((String)"traceId", (String)querytext));
        phraseQueryBuilder.minimumShouldMatch(1);
        return phraseQueryBuilder;
    }

    private static QueryBuilder kvPrecisionQueryBuilder(String key, String value) {
        return QueryBuilders.matchPhrasePrefixQuery((String)key, (Object)value);
    }

    private static int getEndIndex(String querytext) {
        String queryValue;
        if ((querytext = querytext.toLowerCase()).startsWith("\"")) {
            return querytext.substring(1).indexOf("\"") + 2;
        }
        int endIndex = querytext.indexOf("and ");
        if (endIndex == -1 || querytext.substring(0, endIndex).contains("not ")) {
            endIndex = querytext.indexOf("not ");
        }
        if (endIndex == -1) {
            return querytext.length();
        }
        String thisQueryText = querytext.substring(0, endIndex);
        if (thisQueryText.contains(":") && (queryValue = querytext.substring(querytext.indexOf(":") + 1)).startsWith("\"")) {
            endIndex = queryValue.substring(1).indexOf("\"") + 2 + thisQueryText.indexOf(":") + 1;
        }
        return endIndex;
    }

    public boolean isLegalParam(LogContextQuery param) {
        return param != null && !StringUtils.isEmpty((String)param.getLogstore()) && !StringUtils.isEmpty((String)param.getIp()) && !StringUtils.isEmpty((String)param.getFileName()) && param.getLineNumber() != null && !StringUtils.isEmpty((String)param.getTimestamp()) && param.getType() != null && param.getPageSize() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downLogFile(HSSFWorkbook excel, String fileName) throws IOException {
        File file = null;
        FileOutputStream fos = null;
        try {
            file = new File(DoceanConfig.ins().get("download_file_path", "/tmp") + File.separator + fileName);
            file.createNewFile();
            fos = new FileOutputStream(file);
            excel.write((OutputStream)fos);
            Down.down(fileName);
        }
        catch (Exception e) {
            log.error("downLogFile error,fileName:{}", (Object)fileName, (Object)e);
        }
        finally {
            if (excel != null) {
                excel.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    public String esHistogramInterval(Long duration) {
        if ((duration = Long.valueOf(duration / 1000L)) > 86400L) {
            duration = duration / 100L;
            return duration + "s";
        }
        if (duration > 43200L) {
            duration = duration / 80L;
            return duration + "s";
        }
        if (duration > 21600L) {
            duration = duration / 60L;
            return duration + "s";
        }
        if (duration > 3600L) {
            duration = duration / 50L;
            return duration + "s";
        }
        if (duration > 1800L) {
            duration = duration / 40L;
            return duration + "s";
        }
        if (duration > 600L) {
            duration = duration / 30L;
            return duration + "s";
        }
        if (duration > 300L) {
            duration = duration / 25L;
            return duration + "s";
        }
        if (duration > 180L) {
            duration = duration / 20L;
            return duration + "s";
        }
        if (duration > 60L) {
            duration = duration / 15L;
            return duration + "s";
        }
        if (duration > 10L) {
            duration = duration / 10L;
            return duration + "s";
        }
        return "";
    }

    private void processTailNamesToIds(LogQuery logQuery) {
        if (StringUtils.isNotEmpty((String)logQuery.getTail())) {
            List<String> tailNames = List.of(logQuery.getTail().split(","));
            List<MilogLogTailDo> logTailDos = this.tailDao.queryByNames(logQuery.getStoreId(), tailNames);
            List<Long> tailIds = logTailDos.stream().map(MilogLogTailDo::getId).collect(Collectors.toList());
            logQuery.setTailIds(tailIds);
        }
    }

    public static class QueryBuildChain {
        private static final String[] simpleQueryStringSymble = new String[]{"+", "|", "-"};
        private static final String[] simpleQueryStringEndSymble = new String[]{"*"};
        private static final String[] wildcardQuerySymble = new String[]{"*", "?"};

        private static QueryBuilder doChain(String querytext, List<String> keyList) {
            return QueryBuildChain.simpleQueryString(querytext, keyList);
        }

        private static QueryBuilder simpleQueryString(String querytext, List<String> keyList) {
            for (String symble : simpleQueryStringSymble) {
                if (!querytext.contains(symble)) continue;
                return QueryBuilders.simpleQueryStringQuery((String)querytext);
            }
            for (String symble : simpleQueryStringEndSymble) {
                if (!querytext.endsWith(symble)) continue;
                return QueryBuilders.simpleQueryStringQuery((String)querytext);
            }
            return QueryBuildChain.wildcardQuery(querytext, keyList);
        }

        private static QueryBuilder wildcardQuery(String querytext, List<String> keyList) {
            for (String symble : wildcardQuerySymble) {
                if (!querytext.contains(symble)) continue;
                return QueryBuilders.wildcardQuery((String)"message", (String)querytext);
            }
            return QueryBuildChain.multiMatchQuery(querytext, keyList);
        }

        private static QueryBuilder multiMatchQuery(String querytext, List<String> keyList) {
            return QueryBuilders.multiMatchQuery((Object)querytext, (String[])keyList.toArray(new String[keyList.size()]));
        }
    }
}

