/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.codegen.ibatis2.dao.elements;

import java.util.Set;
import java.util.TreeSet;
import org.mybatis.generator.api.DAOMethodNameCalculator;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.PrimitiveTypeWrapper;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.ibatis2.dao.elements.AbstractDAOElementGenerator;

public class InsertMethodGenerator
extends AbstractDAOElementGenerator {
    private boolean generateForJava5;

    public InsertMethodGenerator(boolean generateForJava5) {
        this.generateForJava5 = generateForJava5;
    }

    @Override
    public void addImplementationElements(TopLevelClass topLevelClass) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        if (this.generateForJava5) {
            method.addAnnotation("@Override");
        }
        FullyQualifiedJavaType returnType = method.getReturnType();
        StringBuilder sb = new StringBuilder();
        if (returnType != null) {
            sb.append("Object newKey = ");
        }
        sb.append(this.daoTemplate.getInsertMethod(this.introspectedTable.getIbatis2SqlMapNamespace(), this.introspectedTable.getInsertStatementId(), "record"));
        method.addBodyLine(sb.toString());
        if (returnType != null) {
            if ("Object".equals(returnType.getShortName())) {
                method.addBodyLine("return newKey;");
            } else {
                sb.setLength(0);
                if (returnType.isPrimitive()) {
                    PrimitiveTypeWrapper ptw = returnType.getPrimitiveTypeWrapper();
                    sb.append("return ((");
                    sb.append(ptw.getShortName());
                    sb.append(") newKey");
                    sb.append(").");
                    sb.append(ptw.getToPrimitiveMethod());
                    sb.append(';');
                } else {
                    sb.append("return (");
                    sb.append(returnType.getShortName());
                    sb.append(") newKey;");
                }
                method.addBodyLine(sb.toString());
            }
        }
        if (this.context.getPlugins().clientInsertMethodGenerated(method, topLevelClass, this.introspectedTable)) {
            topLevelClass.addImportedTypes(importedTypes);
            topLevelClass.addMethod(method);
        }
    }

    @Override
    public void addInterfaceElements(Interface interfaze) {
        TreeSet<FullyQualifiedJavaType> importedTypes = new TreeSet<FullyQualifiedJavaType>();
        Method method = this.getMethodShell(importedTypes);
        if (this.context.getPlugins().clientInsertMethodGenerated(method, interfaze, this.introspectedTable)) {
            interfaze.addImportedTypes(importedTypes);
            interfaze.addMethod(method);
        }
    }

    private Method getMethodShell(Set<FullyQualifiedJavaType> importedTypes) {
        FullyQualifiedJavaType returnType;
        Method method = new Method();
        if (this.introspectedTable.getGeneratedKey() != null) {
            IntrospectedColumn introspectedColumn = this.introspectedTable.getColumn(this.introspectedTable.getGeneratedKey().getColumn());
            if (introspectedColumn == null) {
                returnType = null;
            } else {
                returnType = introspectedColumn.getFullyQualifiedJavaType();
                importedTypes.add(returnType);
            }
        } else {
            returnType = null;
        }
        method.setReturnType(returnType);
        method.setVisibility(JavaVisibility.PUBLIC);
        DAOMethodNameCalculator methodNameCalculator = this.getDAOMethodNameCalculator();
        method.setName(methodNameCalculator.getInsertMethodName(this.introspectedTable));
        FullyQualifiedJavaType parameterType = this.introspectedTable.getRules().calculateAllFieldsClass();
        importedTypes.add(parameterType);
        method.addParameter(new Parameter(parameterType, "record"));
        for (FullyQualifiedJavaType fqjt : this.daoTemplate.getCheckedExceptions()) {
            method.addException(fqjt);
            importedTypes.add(fqjt);
        }
        this.context.getCommentGenerator().addGeneralMethodComment(method, this.introspectedTable);
        return method;
    }
}

