/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.nacos.api.docean.NacosReq;
import com.alibaba.nacos.api.docean.NacosRes;
import com.alibaba.nacos.api.docean.PingInfo;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.xiaomi.data.push.rpc.RpcClient;
import com.xiaomi.data.push.rpc.common.InvokeCallback;
import com.xiaomi.data.push.rpc.netty.ResponseFuture;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.task.Task;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoceanClient {
    private static final Logger log = LoggerFactory.getLogger(DoceanClient.class);
    private RpcClient client;
    private String addr = "";
    private boolean init;
    private Gson gson = new Gson();

    public void init() {
        try {
            this.addr = System.getenv("nacos.server.ip");
            if (null == this.addr) {
                return;
            }
            log.info("nacos docean client start:{}", (Object)this.addr);
            this.client = new RpcClient(this.addr);
            this.client.setReconnection(false);
            this.client.setTasks((List)Lists.newArrayList((Object[])new Task[]{new Task(new Runnable(){

                @Override
                public void run() {
                    PingInfo pingInfo = new PingInfo();
                    pingInfo.setPing("ping");
                    RemotingCommand req = RemotingCommand.createRequestCommand((int)1001);
                    req.setBody(DoceanClient.this.gson.toJson((Object)pingInfo).getBytes());
                    DoceanClient.this.client.sendMessage(DoceanClient.this.addr, req, new InvokeCallback(){

                        public void operationComplete(ResponseFuture responseFuture) {
                            if (null != responseFuture.getResponseCommand()) {
                                log.info("ping res:{}", (Object)new String(responseFuture.getResponseCommand().getBody()));
                            }
                        }
                    });
                }
            }, 5L)}));
            this.client.start();
            this.client.init();
            this.init = true;
            log.info("nacos docean client start finish");
        }
        catch (Throwable ex) {
            log.error("init error:{}", (Object)ex.getMessage());
        }
    }

    public NacosRes req(NacosReq req) {
        log.info("docean nacos req:{}", (Object)req.getCmd());
        RemotingCommand res = this.client.sendMessage(this.addr, 10000, this.gson.toJson((Object)req), 2000L);
        byte[] data = res.getBody();
        NacosRes nacosRes = (NacosRes)this.gson.fromJson(new String(data), NacosRes.class);
        return nacosRes;
    }

    public RpcClient getClient() {
        return this.client;
    }

    public String getAddr() {
        return this.addr;
    }

    public boolean isInit() {
        return this.init;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void setClient(RpcClient client) {
        this.client = client;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    public void setGson(Gson gson) {
        this.gson = gson;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DoceanClient)) {
            return false;
        }
        DoceanClient other = (DoceanClient)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RpcClient this$client = this.getClient();
        RpcClient other$client = other.getClient();
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$addr = this.getAddr();
        String other$addr = other.getAddr();
        if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
            return false;
        }
        if (this.isInit() != other.isInit()) {
            return false;
        }
        Gson this$gson = this.getGson();
        Gson other$gson = other.getGson();
        return !(this$gson == null ? other$gson != null : !this$gson.equals(other$gson));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DoceanClient;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RpcClient $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : $client.hashCode());
        String $addr = this.getAddr();
        result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
        result = result * 59 + (this.isInit() ? 79 : 97);
        Gson $gson = this.getGson();
        result = result * 59 + ($gson == null ? 43 : $gson.hashCode());
        return result;
    }

    public String toString() {
        return "DoceanClient(client=" + this.getClient() + ", addr=" + this.getAddr() + ", init=" + this.isInit() + ", gson=" + this.getGson() + ")";
    }
}

