/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.parse;

import cn.hutool.json.JSONUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.parse.AbstractLogParser;
import org.apache.ozhera.log.parse.LogParserData;
import org.apache.ozhera.log.utils.IndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLogParser
extends AbstractLogParser {
    private static final Logger log = LoggerFactory.getLogger(JsonLogParser.class);
    private static final Gson GSON = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).setLenient().create();
    private static final TypeToken<Map<String, Object>> token = new TypeToken<Map<String, Object>>(){};

    public JsonLogParser(LogParserData parserData) {
        super(parserData);
    }

    @Override
    public Map<String, Object> doParse(String logData, String ip, Long lineNum, Long collectStamp, String fileName) {
        return this.doParseSimple(logData, collectStamp);
    }

    @Override
    public Map<String, Object> doParseSimple(String logData, Long collectStamp) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (logData == null || logData.length() == 0) {
            return ret;
        }
        try {
            Map<String, Object> rawLogMap = JsonLogParser.flattenJson(logData);
            List<String> keyNameList = IndexUtils.getKeyListSlice(this.parserData.getKeyList());
            int[] valueIndexList = Arrays.stream(this.parserData.getValueList().split(",")).mapToInt(Integer::parseInt).toArray();
            for (int i = 0; i < keyNameList.size(); ++i) {
                String currentKey;
                if (i >= valueIndexList.length || valueIndexList[i] == -1) continue;
                String value = rawLogMap.getOrDefault(currentKey = keyNameList.get(i), "").toString();
                ret.put(currentKey, StringUtils.isNotEmpty((CharSequence)value) ? value.trim() : value);
            }
            this.validTimestamp(ret, collectStamp);
        }
        catch (Exception e) {
            ret.put("logsource", logData);
        }
        return ret;
    }

    @Override
    public List<String> parseLogData(String logData) throws Exception {
        Map<String, Object> rawLogMap = JsonLogParser.flattenJson(logData);
        ArrayList<String> parsedLogs = new ArrayList<String>();
        for (String key : rawLogMap.keySet()) {
            parsedLogs.add(rawLogMap.getOrDefault(key, "").toString());
        }
        return parsedLogs;
    }

    public static Map<String, Object> flattenJson(String logData) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (logData == null || logData.isEmpty()) {
            return ret;
        }
        try {
            TypeToken<Map<String, Object>> token = new TypeToken<Map<String, Object>>(){};
            Map rawLogMap = (Map)GSON.fromJson(logData, (TypeToken)token);
            ret.putAll(rawLogMap);
            JsonLogParser.flattenMap("", rawLogMap, ret);
        }
        catch (Exception e) {
            ret.put("logsource", logData);
        }
        return ret;
    }

    private static void flattenMap(String prefix, Map<String, Object> source, Map<String, Object> target) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = prefix.isEmpty() ? entry.getKey() : prefix + "." + entry.getKey();
            Object value = entry.getValue();
            if (JSONUtil.isTypeJSON((String)entry.getValue().toString())) {
                if (!(value instanceof Map)) {
                    value = GSON.fromJson(entry.getValue().toString(), token.getType());
                }
                JsonLogParser.flattenMap(key, (Map)value, target);
                continue;
            }
            target.put(key, value);
        }
    }
}

