/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetUtils {
    private static final Logger log = LoggerFactory.getLogger(NetUtils.class);
    private static volatile InetAddress LOCAL_ADDRESS = null;
    public static final String LOCALHOST = "127.0.0.1";
    public static final String ANYHOST = "0.0.0.0";
    public static final String DOCKERHOST = "127.0.0.1";
    private static final Pattern IP_PATTERN = Pattern.compile("\\d{1,3}(\\.\\d{1,3}){3,5}$");
    private static final int RND_PORT_START = 30000;
    private static final int MAX_PORT = 65535;
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final int RND_PORT_RANGE = 10000;

    public static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error("get host name error:{}", (Object)e.getMessage());
            return "";
        }
    }

    public static String getLocalHost() {
        InetAddress address = NetUtils.getLocalAddress();
        return address == null ? "127.0.0.1" : address.getHostAddress();
    }

    public static InetAddress getLocalAddress() {
        InetAddress localAddress;
        if (LOCAL_ADDRESS != null) {
            return LOCAL_ADDRESS;
        }
        LOCAL_ADDRESS = localAddress = NetUtils.getLocalAddress0();
        return localAddress;
    }

    private static InetAddress getLocalAddress0() {
        InetAddress localAddress = null;
        try {
            localAddress = InetAddress.getLocalHost();
            if (localAddress instanceof Inet6Address) {
                Inet6Address address = (Inet6Address)localAddress;
                if (NetUtils.isValidV6Address(address)) {
                    return NetUtils.normalizeV6Address(address);
                }
            } else if (NetUtils.isValidAddress(localAddress)) {
                return localAddress;
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
        }
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            if (null == interfaces) {
                return localAddress;
            }
            while (interfaces.hasMoreElements()) {
                try {
                    NetworkInterface network = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = network.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        try {
                            InetAddress address = addresses.nextElement();
                            if (address instanceof Inet6Address) {
                                Inet6Address v6Address = (Inet6Address)address;
                                if (!NetUtils.isValidV6Address(v6Address)) continue;
                                return NetUtils.normalizeV6Address(v6Address);
                            }
                            if (!NetUtils.isValidAddress(address)) continue;
                            return address;
                        }
                        catch (Throwable e) {
                            log.warn(e.getMessage());
                        }
                    }
                }
                catch (Throwable e) {
                    log.warn(e.getMessage());
                }
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage());
        }
        return localAddress;
    }

    static boolean isValidV6Address(Inet6Address address) {
        boolean preferIpv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        if (!preferIpv6) {
            return false;
        }
        try {
            return address.isReachable(100);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    static InetAddress normalizeV6Address(Inet6Address address) {
        String addr = address.getHostAddress();
        int i = addr.lastIndexOf(37);
        if (i > 0) {
            try {
                return InetAddress.getByName(addr.substring(0, i) + "%" + address.getScopeId());
            }
            catch (UnknownHostException e) {
                log.debug("Unknown IPV6 address: ", (Throwable)e);
            }
        }
        return address;
    }

    static boolean isValidAddress(InetAddress address) {
        if (address == null || address.isLoopbackAddress()) {
            return false;
        }
        String name = address.getHostAddress();
        return name != null && !ANYHOST.equals(name) && !"127.0.0.1".equals(name) && !"127.0.0.1".equals(name) && IP_PATTERN.matcher(name).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailablePort(int port) {
        if (port <= 0) {
            return NetUtils.getAvailablePort();
        }
        for (int i = port; i < 65535; ++i) {
            ServerSocket ss = null;
            try {
                ss = new ServerSocket(i);
                int n = i;
                return n;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailableUdpPort(int port) {
        if (port <= 0) {
            return NetUtils.getUdpAvailablePort();
        }
        for (int i = port; i < 65535; ++i) {
            try (DatagramSocket ss = null;){
                ss = new DatagramSocket(i);
                int n = i;
                return n;
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getAvailablePort() {
        ServerSocket ss = null;
        try {
            ss = new ServerSocket();
            ss.bind(null);
            int n = ss.getLocalPort();
            return n;
        }
        catch (IOException e) {
            int n = NetUtils.getRandomPort();
            return n;
        }
        finally {
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getUdpAvailablePort() {
        try (DatagramSocket ss = null;){
            ss = new DatagramSocket();
            ss.bind(null);
            int n = ss.getLocalPort();
            return n;
        }
    }

    public static List<String> queryIpWithDomain(String domain) {
        ArrayList ips = Lists.newArrayList();
        try {
            InetAddress[] addresses = InetAddress.getAllByName(domain);
            for (int i = 0; i < addresses.length; ++i) {
                ips.add(addresses[i].getHostAddress());
            }
        }
        catch (Exception e) {
            log.error("queryIpWithDomain with error:{}", (Object)domain, (Object)e);
        }
        return ips;
    }

    public static int getRandomPort() {
        return 30000 + RANDOM.nextInt(10000);
    }
}

