/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc;

import com.xiaomi.youpin.docean.Mvc;
import com.xiaomi.youpin.docean.mvc.MvcContext;
import com.xiaomi.youpin.docean.mvc.common.MvcConst;

public class ContextHolder {
    private static ThreadLocal<ContextHolder> context = ThreadLocal.withInitial(() -> new ContextHolder());
    private MvcContext mvcContext;
    private static VirtualThreadContextHolder virtualThreadContextHolder = new VirtualThreadContextHolder();

    public void set(MvcContext mvcContext) {
        this.mvcContext = mvcContext;
    }

    public MvcContext get() {
        return this.mvcContext;
    }

    private static ContextHolder getContext0() {
        return context.get();
    }

    public static ContextHolder getContext() {
        boolean virtualThread = Mvc.ins().getMvcConfig().isVirtualThread();
        if (virtualThread) {
            return virtualThreadContextHolder;
        }
        return ContextHolder.getContext0();
    }

    public void close() {
        context.remove();
    }

    private static class VirtualThreadContextHolder
    extends ContextHolder {
        private VirtualThreadContextHolder() {
        }

        @Override
        public MvcContext get() {
            return MvcConst.MVC_CONTEXT.get();
        }
    }
}

