/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean;

import com.google.common.collect.Maps;
import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Lookup;
import com.xiaomi.youpin.docean.aop.AopContext;
import com.xiaomi.youpin.docean.aop.CglibProxy;
import com.xiaomi.youpin.docean.aop.EnhanceInterceptor;
import com.xiaomi.youpin.docean.aop.IProxy;
import com.xiaomi.youpin.docean.aop.ProceedingJoinPoint;
import com.xiaomi.youpin.docean.aop.Proxy;
import com.xiaomi.youpin.docean.aop.anno.After;
import com.xiaomi.youpin.docean.aop.anno.Aspect;
import com.xiaomi.youpin.docean.aop.anno.Before;
import com.xiaomi.youpin.docean.common.DoceanConfig;
import com.xiaomi.youpin.docean.common.ReflectUtils;
import com.xiaomi.youpin.docean.interceptor.LookupInterceptor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aop {
    private static final Logger log = LoggerFactory.getLogger(Aop.class);
    private LinkedHashMap<Class, EnhanceInterceptor> interceptorMap = new LinkedHashMap();
    private boolean cglib = true;
    private String name = "aop";

    private Aop() {
    }

    public Aop init(LinkedHashMap<Class, EnhanceInterceptor> map) {
        this.interceptorMap.put(Lookup.class, new LookupInterceptor());
        this.interceptorMap.putAll(map);
        this.cglib = DoceanConfig.ins().get("cglib", "true").equals("true");
        log.info("aop use cglib:{}", (Object)this.cglib);
        return this;
    }

    public Aop useAspect(Ioc ioc, String ... packages) {
        Ioc.create(Thread.currentThread().getContextClassLoader()).cleanAnnos().setAnnos(Aspect.class).init(packages).getBeansWithAnnotation(Aspect.class).values().forEach(it -> {
            Arrays.stream(it.getClass().getDeclaredMethods()).forEach(m -> {
                Optional.ofNullable(m.getAnnotation(Before.class)).ifPresent(a -> {
                    log.info("aop before class:{}", it.getClass());
                    EnhanceInterceptor interceptor = new EnhanceInterceptor(this, (Method)m, it){
                        final /* synthetic */ Method val$m;
                        final /* synthetic */ Object val$it;
                        {
                            this.val$m = method;
                            this.val$it = object;
                        }

                        @Override
                        public void before(AopContext aopContext, Method method, Object[] args) {
                            ProceedingJoinPoint point = new ProceedingJoinPoint();
                            point.setArgs(args);
                            point.setMethod(method);
                            this.val$m.invoke(this.val$it, point);
                        }
                    };
                    this.interceptorMap.put(a.anno(), interceptor);
                });
                Optional.ofNullable(m.getAnnotation(After.class)).ifPresent(a -> {
                    EnhanceInterceptor interceptor = new EnhanceInterceptor(this, (Method)m, it){
                        final /* synthetic */ Method val$m;
                        final /* synthetic */ Object val$it;
                        {
                            this.val$m = method;
                            this.val$it = object;
                        }

                        @Override
                        public Object after(AopContext context, Method method, Object res) {
                            ProceedingJoinPoint point = new ProceedingJoinPoint();
                            point.setMethod(method);
                            point.setRes(res);
                            return this.val$m.invoke(this.val$it, point);
                        }
                    };
                    this.interceptorMap.put(a.anno(), interceptor);
                });
            });
            ioc.putBean(it);
        });
        return this;
    }

    public Aop useAspect(Ioc ioc, ClassLoader classLoader, String ... packages) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        Ioc.create(classLoader).cleanAnnos().setAnnos(Aspect.class).init(packages).getBeansWithAnnotation(Aspect.class).values().forEach(it -> {
            Arrays.stream(it.getClass().getDeclaredMethods()).forEach(m -> {
                Optional.ofNullable(m.getAnnotation(Before.class)).ifPresent(a -> {
                    EnhanceInterceptor interceptor = new EnhanceInterceptor(this, (Method)m, it){
                        final /* synthetic */ Method val$m;
                        final /* synthetic */ Object val$it;
                        {
                            this.val$m = method;
                            this.val$it = object;
                        }

                        @Override
                        public void before(AopContext aopContext, Method method, Object[] args) {
                            ProceedingJoinPoint point = new ProceedingJoinPoint();
                            point.setArgs(args);
                            this.val$m.invoke(this.val$it, point);
                        }
                    };
                    this.interceptorMap.put(a.anno(), interceptor);
                });
                Optional.ofNullable(m.getAnnotation(After.class)).ifPresent(a -> {
                    EnhanceInterceptor interceptor = new EnhanceInterceptor(this, (Method)m, it){
                        final /* synthetic */ Method val$m;
                        final /* synthetic */ Object val$it;
                        {
                            this.val$m = method;
                            this.val$it = object;
                        }

                        @Override
                        public Object after(AopContext context, Method method, Object res) {
                            ProceedingJoinPoint point = new ProceedingJoinPoint();
                            point.setRes(res);
                            return this.val$m.invoke(this.val$it, point);
                        }
                    };
                    this.interceptorMap.put(a.anno(), interceptor);
                });
            });
            ioc.putBean(it);
        });
        return this;
    }

    private boolean needEnhance(Class clazz, Class annotation) {
        return Arrays.stream(clazz.getMethods()).filter(it -> Optional.ofNullable(it.getAnnotation(annotation)).isPresent()).findAny().isPresent();
    }

    public <T> T enhance(Class clazz) {
        Object obj = null;
        LinkedHashMap interceptors = Maps.newLinkedHashMap();
        for (Map.Entry<Class, EnhanceInterceptor> entry : this.interceptorMap.entrySet()) {
            if (!this.needEnhance(clazz, entry.getKey())) continue;
            interceptors.put(entry.getKey(), entry.getValue());
        }
        if (interceptors.size() > 0) {
            log.info("enhance class:{}", (Object)clazz);
            return this.enhance(clazz, interceptors);
        }
        return Optional.ofNullable(obj).orElse(ReflectUtils.getInstance((Class)clazz));
    }

    public <T> T enhance(Class clazz, LinkedHashMap<Class, EnhanceInterceptor> interceptor) {
        IProxy proxy = this.cglib ? new CglibProxy(clazz, interceptor) : new Proxy(clazz, interceptor);
        return proxy.getInstance();
    }

    public static Aop ins() {
        return LazyHolder.ins;
    }

    public LinkedHashMap<Class, EnhanceInterceptor> getInterceptorMap() {
        return this.interceptorMap;
    }

    public String getName() {
        return this.name;
    }

    public static final class LazyHolder {
        private static final Aop ins = new Aop();
    }
}

