/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.extension.toolkit;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class JdbcUtils {
    private static final Log logger = LogFactory.getLog(JdbcUtils.class);

    public static DbType getDbType(Executor executor) {
        try {
            Connection conn = executor.getTransaction().getConnection();
            return JdbcUtils.getDbType(conn.getMetaData().getURL());
        }
        catch (SQLException e) {
            throw ExceptionUtils.mpe((Throwable)e);
        }
    }

    public static DbType getDbType(String jdbcUrl) {
        Assert.isFalse((boolean)StringUtils.isBlank((CharSequence)jdbcUrl), (String)"Error: The jdbcUrl is Null, Cannot read database type", (Object[])new Object[0]);
        String url = jdbcUrl.toLowerCase();
        if (url.contains(":mysql:") || url.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (url.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (url.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (url.contains(":sqlserver:") || url.contains(":microsoft:")) {
            return DbType.SQL_SERVER2005;
        }
        if (url.contains(":sqlserver2012:")) {
            return DbType.SQL_SERVER;
        }
        if (url.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (url.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (url.contains(":db2:")) {
            return DbType.DB2;
        }
        if (url.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (url.contains(":h2:")) {
            return DbType.H2;
        }
        if (JdbcUtils.regexFind(":dm\\d*:", url)) {
            return DbType.DM;
        }
        if (url.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (JdbcUtils.regexFind(":kingbase\\d*:", url)) {
            return DbType.KINGBASE_ES;
        }
        if (url.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        if (jdbcUrl.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (jdbcUrl.contains(":gbase:")) {
            return DbType.GBASE;
        }
        if (jdbcUrl.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (jdbcUrl.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (jdbcUrl.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        if (jdbcUrl.contains(":oceanbase:")) {
            return DbType.OCEAN_BASE;
        }
        if (url.contains(":highgo:")) {
            return DbType.HighGo;
        }
        logger.warn("The jdbcUrl is " + jdbcUrl + ", Mybatis Plus Cannot Read Database type or The Database's Not Supported!");
        return DbType.OTHER;
    }

    public static boolean regexFind(String regex, CharSequence input) {
        if (null == input) {
            return false;
        }
        return Pattern.compile(regex).matcher(input).find();
    }
}

