/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.common;

import com.google.gson.Gson;
import com.xiaomi.youpin.docean.anno.Component;
import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.apps.DaemonSet;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.storage.StorageClass;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Resource;
import org.apache.ozhera.operator.bo.HeraBootstrap;
import org.apache.ozhera.operator.bo.HeraBootstrapList;
import org.apache.ozhera.operator.bo.HeraResource;
import org.apache.ozhera.operator.common.ResourceTypeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class K8sUtilBean {
    private static final Logger log = LoggerFactory.getLogger(K8sUtilBean.class);
    private Gson gson = new Gson();
    @Resource
    private KubernetesClient kubernetesClient;
    @Resource(name="heraClient")
    private MixedOperation<HeraBootstrap, HeraBootstrapList, io.fabric8.kubernetes.client.dsl.Resource<HeraBootstrap>> heraClient;
    @Resource(name="deploymentClient")
    private MixedOperation<Deployment, DeploymentList, io.fabric8.kubernetes.client.dsl.Resource<Deployment>> deploymentClient;

    public void applyResource(HeraResource heraResource, ObjectMeta objectMeta, String action) {
        if (null == heraResource.getNeedCreate() || !heraResource.getNeedCreate().booleanValue()) {
            return;
        }
        if (ResourceTypeEnum.SERVICE_CHECK.getTypeName().equals(heraResource.getResourceType())) {
            log.warn("SERVICE_CHECK type resource no need to apply");
            return;
        }
        String namespace = objectMeta.getNamespace();
        String yaml = heraResource.getYamlStr();
        this.applyYaml(yaml, namespace, action);
    }

    public void applyYaml(String yaml, String namespace, String action) {
        log.warn("applyYaml action:{}, ply yaml:{}", (Object)action, (Object)yaml);
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(yaml.getBytes("UTF-8"));){
            ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable metaDataes = this.kubernetesClient.load((InputStream)inputStream);
            List hasMetadataList = (List)metaDataes.get();
            for (HasMetadata hasMetadata : hasMetadataList) {
                if (hasMetadata instanceof Service) {
                    Service heraService = (Service)hasMetadata;
                    if ("delete".equals(action)) {
                        ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).delete((Object[])new Service[]{heraService});
                        continue;
                    }
                    ((NonNamespaceOperation)this.kubernetesClient.services().inNamespace(namespace)).createOrReplace((Object[])new Service[]{heraService});
                    continue;
                }
                if (hasMetadata instanceof PersistentVolume) {
                    PersistentVolume heraPv = (PersistentVolume)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.persistentVolumes().delete((Object[])new PersistentVolume[]{heraPv});
                        continue;
                    }
                    this.kubernetesClient.persistentVolumes().createOrReplace((Object[])new PersistentVolume[]{heraPv});
                    continue;
                }
                if (hasMetadata instanceof StorageClass) {
                    StorageClass heraStorageClass = (StorageClass)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.storage().storageClasses().delete((Object[])new StorageClass[]{heraStorageClass});
                        continue;
                    }
                    this.kubernetesClient.storage().storageClasses().createOrReplace((Object[])new StorageClass[]{heraStorageClass});
                    continue;
                }
                if (hasMetadata instanceof PersistentVolumeClaim) {
                    PersistentVolumeClaim heraPvc = (PersistentVolumeClaim)hasMetadata;
                    if ("delete".equals(action)) {
                        ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).delete((Object[])new PersistentVolumeClaim[]{heraPvc});
                        continue;
                    }
                    ((NonNamespaceOperation)this.kubernetesClient.persistentVolumeClaims().inNamespace(namespace)).createOrReplace((Object[])new PersistentVolumeClaim[]{heraPvc});
                    continue;
                }
                if (hasMetadata instanceof Deployment) {
                    Deployment heraDeployment = (Deployment)hasMetadata;
                    if ("delete".equals(action)) {
                        ((NonNamespaceOperation)this.deploymentClient.inNamespace(namespace)).delete((Object[])new Deployment[]{heraDeployment});
                        continue;
                    }
                    Deployment deployment = (Deployment)((NonNamespaceOperation)this.deploymentClient.inNamespace(namespace)).createOrReplace((Object[])new Deployment[]{heraDeployment});
                    log.warn("###deployment status:{}", (Object)this.gson.toJson((Object)deployment.getStatus()));
                    continue;
                }
                if (hasMetadata instanceof ClusterRoleBinding) {
                    ClusterRoleBinding heraClusterRoleBinding = (ClusterRoleBinding)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.rbac().clusterRoleBindings().delete((Object[])new ClusterRoleBinding[]{heraClusterRoleBinding});
                        continue;
                    }
                    this.kubernetesClient.rbac().clusterRoleBindings().createOrReplace((Object[])new ClusterRoleBinding[]{heraClusterRoleBinding});
                    continue;
                }
                if (hasMetadata instanceof ClusterRole) {
                    ClusterRole heraClusterRole = (ClusterRole)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.rbac().clusterRoles().delete((Object[])new ClusterRole[]{heraClusterRole});
                        continue;
                    }
                    this.kubernetesClient.rbac().clusterRoles().createOrReplace((Object[])new ClusterRole[]{heraClusterRole});
                    continue;
                }
                if (hasMetadata instanceof ServiceAccount) {
                    ServiceAccount heraServiceAccount = (ServiceAccount)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.serviceAccounts().delete((Object[])new ServiceAccount[]{heraServiceAccount});
                        continue;
                    }
                    this.kubernetesClient.serviceAccounts().createOrReplace((Object[])new ServiceAccount[]{heraServiceAccount});
                    continue;
                }
                if (hasMetadata instanceof ConfigMap) {
                    ConfigMap heraConfigMap = (ConfigMap)hasMetadata;
                    if ("delete".equals(action)) {
                        ((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(namespace)).delete((Object[])new ConfigMap[]{heraConfigMap});
                        continue;
                    }
                    ((NonNamespaceOperation)this.kubernetesClient.configMaps().inNamespace(namespace)).createOrReplace((Object[])new ConfigMap[]{heraConfigMap});
                    continue;
                }
                if (hasMetadata instanceof DaemonSet) {
                    DaemonSet heraDaemonSet = (DaemonSet)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.apps().daemonSets().delete((Object[])new DaemonSet[]{heraDaemonSet});
                        continue;
                    }
                    this.kubernetesClient.apps().daemonSets().createOrReplace((Object[])new DaemonSet[]{heraDaemonSet});
                    continue;
                }
                if (hasMetadata instanceof StatefulSet) {
                    StatefulSet heraStatefulSet = (StatefulSet)hasMetadata;
                    if ("delete".equals(action)) {
                        this.kubernetesClient.apps().statefulSets().delete((Object[])new StatefulSet[]{heraStatefulSet});
                        continue;
                    }
                    this.kubernetesClient.apps().statefulSets().createOrReplace((Object[])new StatefulSet[]{heraStatefulSet});
                    continue;
                }
                log.warn("not support k8s kind:{}, yaml:{}", (Object)hasMetadata.getKind(), (Object)this.gson.toJson((Object)hasMetadata.getMetadata()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

