/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mvc;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.NutIoc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.lang.Mirror;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.IocProvider;
import org.nutz.mvc.NutConfig;
import org.nutz.resource.Scans;

public class NutMvcListener
implements ServletContextListener,
IocProvider {
    public static String PROP_LOCATION = "nutz-properties-location";
    public static String IOCBY = "iocby";
    protected ServletContext sc;
    protected PropertiesProxy pp;
    private static final Log log = Logs.get();
    protected static Ioc ioc;

    public static Ioc ioc() {
        if (ioc == null) {
            throw new IllegalArgumentException("NutMvcListener NOT init!!! check your web.xml!!");
        }
        return ioc;
    }

    public void contextInitialized(ServletContextEvent event) {
        this.sc = event.getServletContext();
        Scans.me().init(this.sc);
        this.findConfig();
        this.initIoc();
    }

    protected void findConfig() {
        String propLocation = this.sc.getInitParameter(PROP_LOCATION);
        if (Strings.isBlank(propLocation)) {
            propLocation = "nutz.properties";
        }
        PropertiesProxy pp = new PropertiesProxy();
        Enumeration params = this.sc.getInitParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            if (!name.startsWith("nutz-")) continue;
            pp.put(name, this.sc.getInitParameter(name).trim());
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("/" + propLocation);
        if (in == null) {
            in = this.sc.getResourceAsStream("/WEB-INF/" + propLocation);
        }
        if (in == null) {
            log.debug(propLocation + " not found");
        } else {
            pp = new PropertiesProxy(in);
            Streams.safeClose(in);
        }
        this.pp = pp;
    }

    protected void initIoc() {
        String key = "nutz-" + IOCBY;
        String iocby = this.pp.get(key);
        if (Strings.isBlank(iocby)) {
            throw new RuntimeException(key + " not found nutz.ini or context-param !!");
        }
        Object[] args = Strings.splitIgnoreBlank(iocby);
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].trim();
        }
        log.info("init Ioc by args=" + Arrays.toString(args));
        try {
            ioc = new NutIoc(new ComboIocLoader((String[])args));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        boolean deposed;
        Ioc ioc;
        if (NutMvcListener.ioc() != null && (ioc = NutMvcListener.ioc()) instanceof NutIoc && !(deposed = ((Boolean)Mirror.me(ioc).getValue((Object)ioc, "deposed")).booleanValue())) {
            ioc.depose();
        }
    }

    @Override
    public Ioc create(NutConfig config, String[] args) {
        if (args != null && args.length > 0 && log != null) {
            log.warn("args ignore : " + Arrays.toString(args));
        }
        return NutMvcListener.ioc();
    }
}

