/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.log.impl;

import java.util.Arrays;
import org.nutz.log.Log;
import org.nutz.log.impl.LogInfo;

public abstract class AbstractLog
implements Log {
    protected boolean isFatalEnabled = true;
    protected boolean isErrorEnabled = true;
    protected boolean isWarnEnabled = true;
    protected boolean isInfoEnabled = false;
    protected boolean isDebugEnabled = false;
    protected boolean isTraceEnabled = false;
    protected static final int LEVEL_FATAL = 50;
    protected static final int LEVEL_ERROR = 40;
    protected static final int LEVEL_WARN = 30;
    protected static final int LEVEL_INFO = 20;
    protected static final int LEVEL_DEBUG = 10;
    protected static final int LEVEL_TRACE = 0;
    private static final LogInfo LOGINFO_ERROR = new LogInfo();
    private static final LogInfo LOGINFO_NULL = new LogInfo();
    protected String tag = "";

    public static int level(String str) {
        if (null != str) {
            if ("F".equals(str) || "fatal".equals(str)) {
                return 50;
            }
            if ("E".equals(str) || "error".equals(str)) {
                return 40;
            }
            if ("W".equals(str) || "warn".equals(str)) {
                return 30;
            }
            if ("I".equals(str) || "info".equals(str)) {
                return 20;
            }
            if ("D".equals(str) || "debug".equals(str)) {
                return 10;
            }
            if ("T".equals(str) || "trace".equals(str)) {
                return 0;
            }
        }
        return 20;
    }

    protected abstract void log(int var1, Object var2, Throwable var3);

    protected void log(int level, LogInfo info) {
        this.log(level, info.message, info.e);
    }

    private LogInfo makeInfo(Object obj, Object ... args) {
        if (obj == null) {
            return LOGINFO_NULL;
        }
        try {
            LogInfo info = new LogInfo();
            if (obj instanceof Throwable) {
                info.e = (Throwable)obj;
                info.message = info.e.getMessage();
            } else if (args == null || args.length == 0) {
                info.message = obj.toString();
            } else {
                info.message = String.format(obj.toString(), args);
                if (args[args.length - 1] instanceof Throwable) {
                    info.e = (Throwable)args[args.length - 1];
                }
            }
            return info;
        }
        catch (Throwable e) {
            if (this.isWarnEnabled()) {
                this.warn("String format fail in log , fmt = " + obj + " , args = " + Arrays.toString(args), e);
            }
            return LOGINFO_ERROR;
        }
    }

    @Override
    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.log(10, this.makeInfo(message, new Object[0]));
        }
    }

    @Override
    public void debugf(String fmt, Object ... args) {
        if (this.isDebugEnabled()) {
            this.log(10, this.makeInfo(fmt, args));
        }
    }

    @Override
    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.log(40, this.makeInfo(message, new Object[0]));
        }
    }

    @Override
    public void errorf(String fmt, Object ... args) {
        if (this.isErrorEnabled()) {
            this.log(40, this.makeInfo(fmt, args));
        }
    }

    @Override
    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.log(50, this.makeInfo(message, new Object[0]));
        }
    }

    @Override
    public void fatalf(String fmt, Object ... args) {
        if (this.isFatalEnabled()) {
            this.log(50, this.makeInfo(fmt, args));
        }
    }

    @Override
    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.log(20, this.makeInfo(message, new Object[0]));
        }
    }

    @Override
    public void infof(String fmt, Object ... args) {
        if (this.isInfoEnabled()) {
            this.log(20, this.makeInfo(fmt, args));
        }
    }

    @Override
    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.log(0, this.makeInfo(message, new Object[0]));
        }
    }

    @Override
    public void tracef(String fmt, Object ... args) {
        if (this.isTraceEnabled()) {
            this.log(0, this.makeInfo(fmt, args));
        }
    }

    @Override
    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.log(30, this.makeInfo(message, new Object[0]));
        }
    }

    @Override
    public void warnf(String fmt, Object ... args) {
        if (this.isWarnEnabled()) {
            this.log(30, this.makeInfo(fmt, args));
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isDebugEnabled;
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isErrorEnabled;
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isFatalEnabled;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isInfoEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isWarnEnabled;
    }

    @Override
    public Log setTag(String tag) {
        this.tag = tag;
        return this;
    }

    static {
        AbstractLog.LOGINFO_ERROR.message = "!!!!Log Fail!!";
        AbstractLog.LOGINFO_NULL.message = "null";
    }
}

