/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.interceptor.async;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.aop.interceptor.async.Async;
import org.nutz.aop.interceptor.async._async_task;

public class AsyncMethodInterceptor
implements MethodInterceptor {
    protected ExecutorService es;
    protected boolean hasFuture;

    public AsyncMethodInterceptor(Method method, Async async, ExecutorService es) {
        this.es = es;
        this.hasFuture = Future.class.isAssignableFrom(method.getReturnType());
    }

    @Override
    public void filter(InterceptorChain chain) throws Throwable {
        Future<Object> future = this.es.submit(new _async_task(chain, this.hasFuture));
        if (this.hasFuture) {
            chain.setReturnValue(future);
        }
    }
}

