/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hertzbeat.alert.dto.SkyWalkingExternAlert;
import org.apache.hertzbeat.alert.reduce.AlarmCommonReduce;
import org.apache.hertzbeat.alert.service.ExternAlertService;
import org.apache.hertzbeat.common.entity.alerter.SingleAlert;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SkyWalkingExternAlertService
implements ExternAlertService {
    private static final Logger log = LoggerFactory.getLogger(SkyWalkingExternAlertService.class);
    @Autowired
    private AlarmCommonReduce alarmCommonReduce;

    @Override
    public void addExternAlert(String content) {
        TypeReference<List<SkyWalkingExternAlert>> typeReference = new TypeReference<List<SkyWalkingExternAlert>>(){};
        List alerts = (List)JsonUtil.fromJson((String)content, (TypeReference)typeReference);
        if (alerts == null || alerts.isEmpty()) {
            log.warn("Parse SkyWalking extern alert content failed! content: {}", (Object)content);
            return;
        }
        for (SkyWalkingExternAlert alert : alerts) {
            SingleAlert singleAlert = SingleAlert.builder().content(alert.getAlarmMessage()).status("firing").activeAt(Long.valueOf(Instant.now().toEpochMilli())).startAt(Long.valueOf(alert.getStartTime() != null ? alert.getStartTime().longValue() : Instant.now().toEpochMilli())).labels(this.acquireAlertLabels(alert)).annotations(this.acquireAlertAnnotations(alert)).triggerTimes(Integer.valueOf(1)).build();
            this.alarmCommonReduce.reduceAndSendAlarm(singleAlert);
        }
    }

    @Override
    public String supportSource() {
        return "skywalking";
    }

    private Map<String, String> acquireAlertLabels(SkyWalkingExternAlert externAlert) {
        HashMap<String, String> labels = new HashMap<String, String>(8);
        labels.put("__source__", "skywalking");
        List<SkyWalkingExternAlert.Tag> tags = externAlert.getTags();
        if (tags == null || tags.isEmpty()) {
            return labels;
        }
        tags.forEach(tag -> labels.put(tag.getKey(), tag.getValue()));
        return labels;
    }

    private Map<String, String> acquireAlertAnnotations(SkyWalkingExternAlert externAlert) {
        HashMap<String, String> annotations = new HashMap<String, String>(8);
        annotations.putIfAbsent("scope", externAlert.getScope());
        annotations.putIfAbsent("name", externAlert.getName());
        annotations.putIfAbsent("id0", externAlert.getId0());
        annotations.putIfAbsent("id1", externAlert.getId1());
        annotations.putIfAbsent("ruleName", externAlert.getRuleName());
        return annotations;
    }
}

