/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.service.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.hertzbeat.alert.config.AlibabaSmsProperties;
import org.apache.hertzbeat.alert.service.SmsClient;
import org.apache.hertzbeat.alert.util.CryptoUtils;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.apache.hertzbeat.common.support.exception.SendMessageException;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlibabaSmsClientImpl
implements SmsClient {
    private static final Logger log = LoggerFactory.getLogger(AlibabaSmsClientImpl.class);
    private static final String API_VERSION = "2017-05-25";
    private static final String ACTION = "SendSms";
    private static final String HOST = "dysmsapi.aliyuncs.com";
    private static final String ALGORITHM = "ACS3-HMAC-SHA256";
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String signName;
    private final String templateCode;

    public AlibabaSmsClientImpl(AlibabaSmsProperties config) {
        if (config != null) {
            this.accessKeyId = config.getAccessKeyId();
            this.accessKeySecret = config.getAccessKeySecret();
            this.signName = config.getSignName();
            this.templateCode = config.getTemplateCode();
        } else {
            this.accessKeyId = "";
            this.accessKeySecret = "";
            this.signName = "";
            this.templateCode = "";
        }
    }

    @Override
    public void sendMessage(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) {
        String instance = null;
        String priority = null;
        String content = null;
        if (alert.getCommonLabels() != null) {
            instance = (String)alert.getCommonLabels().get("instance");
            priority = (String)alert.getCommonLabels().get("priority");
            content = (String)alert.getCommonAnnotations().get("summary");
            String string = content = content == null ? (String)alert.getCommonAnnotations().get("description") : content;
            if (content == null) {
                content = alert.getCommonAnnotations().values().stream().findFirst().orElse(null);
            }
        }
        HashMap<String, String> templateParam = new HashMap<String, String>();
        templateParam.put("instance", instance == null ? alert.getGroupKey() : instance);
        templateParam.put("priority", priority == null ? "unknown" : priority);
        templateParam.put("content", content);
        this.sendSms(receiver.getPhone(), JsonUtil.toJson(templateParam));
    }

    private void sendSms(String phoneNumber, String templateParam) {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            TreeMap<String, String> queryParams = new TreeMap<String, String>();
            queryParams.put("PhoneNumbers", phoneNumber);
            queryParams.put("SignName", this.signName);
            queryParams.put("TemplateCode", this.templateCode);
            queryParams.put("TemplateParam", templateParam);
            StringBuilder canonicalQueryString = new StringBuilder();
            queryParams.forEach((key, value) -> {
                if (canonicalQueryString.length() > 0) {
                    canonicalQueryString.append("&");
                }
                canonicalQueryString.append(this.percentEncode((String)key)).append("=").append(this.percentEncode((String)value));
            });
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            sdf.setTimeZone(new SimpleTimeZone(0, "GMT"));
            String timestamp = sdf.format(new Date());
            String nonce = UUID.randomUUID().toString();
            String authorization = this.calculateAuthorization(canonicalQueryString.toString(), timestamp, nonce);
            String url = "https://dysmsapi.aliyuncs.com/?" + canonicalQueryString;
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/json");
            httpPost.setHeader("Host", HOST);
            httpPost.setHeader("Authorization", authorization);
            httpPost.setHeader("x-acs-action", ACTION);
            httpPost.setHeader("x-acs-version", API_VERSION);
            httpPost.setHeader("x-acs-date", timestamp);
            httpPost.setHeader("x-acs-signature-nonce", nonce);
            httpPost.setHeader("x-acs-content-sha256", CryptoUtils.sha256Hex(""));
            log.info("Sending Alibaba SMS request to {}", (Object)(url + ", params: " + templateParam + "headers: " + Arrays.toString(httpPost.getAllHeaders())));
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                int statusCode = response.getStatusLine().getStatusCode();
                String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                log.info("SMS response status: {}, body: {}", (Object)statusCode, (Object)responseBody);
                if (statusCode != 200) {
                    throw new SendMessageException("HTTP request failed with status code: " + statusCode + ", response: " + responseBody);
                }
                JsonNode jsonResponse = JsonUtil.fromJson((String)responseBody);
                String code = jsonResponse.get("Code").asText();
                if (!"OK".equals(code)) {
                    String message = jsonResponse.get("Message").asText();
                    throw new SendMessageException(code + ":" + message);
                }
                log.info("Successfully sent SMS to phone: {}", (Object)phoneNumber);
            }
        }
        catch (Exception e) {
            log.warn("Failed to send SMS: {}", (Object)e.getMessage());
            throw new SendMessageException(e.getMessage());
        }
    }

    private String calculateAuthorization(String canonicalQueryString, String timestamp, String nonce) {
        try {
            String canonicalRequest = this.buildCanonicalRequest(canonicalQueryString, timestamp, nonce);
            String stringToSign = "ACS3-HMAC-SHA256\n" + CryptoUtils.sha256Hex(canonicalRequest);
            String signature = CryptoUtils.hmacSha256Hex(this.accessKeySecret, stringToSign);
            return "ACS3-HMAC-SHA256 Credential=" + this.accessKeyId + ",SignedHeaders=host;x-acs-action;x-acs-content-sha256;x-acs-date;x-acs-signature-nonce;x-acs-version,Signature=" + signature;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to calculate authorization", e);
        }
    }

    private String buildCanonicalRequest(String canonicalQueryString, String timestamp, String nonce) {
        return "POST\n/\n" + canonicalQueryString + "\nhost:dysmsapi.aliyuncs.com\nx-acs-action:SendSms\nx-acs-content-sha256:" + CryptoUtils.sha256Hex("") + "\nx-acs-date:" + timestamp + "\nx-acs-signature-nonce:" + nonce + "\nx-acs-version:2017-05-25\n\nhost;x-acs-action;x-acs-content-sha256;x-acs-date;x-acs-signature-nonce;x-acs-version\n" + CryptoUtils.sha256Hex("");
    }

    private String percentEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8).replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to encode value", e);
        }
    }

    @Override
    public String getType() {
        return "alibaba";
    }

    @Override
    public boolean checkConfig() {
        return !this.accessKeyId.isBlank() && !this.accessKeySecret.isBlank() && !this.signName.isBlank() && !this.templateCode.isBlank();
    }
}

