/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.descriptors.partitioning.RangePartition;
import org.eclipse.persistence.descriptors.partitioning.RangePartitioningPolicy;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.FieldPartitioningMetadata;
import org.eclipse.persistence.internal.jpa.metadata.partitioning.RangePartitionMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

public class RangePartitioningMetadata
extends FieldPartitioningMetadata {
    protected List<RangePartitionMetadata> partitions;

    public RangePartitioningMetadata() {
        super("<range-partitioning>");
    }

    public RangePartitioningMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.partitions = new ArrayList<RangePartitionMetadata>();
        for (Object partitionAnnotation : annotation.getAttributeArray("partitions")) {
            this.partitions.add(new RangePartitionMetadata((MetadataAnnotation)partitionAnnotation, accessor));
        }
    }

    @Override
    public PartitioningPolicy buildPolicy() {
        RangePartitioningPolicy policy = new RangePartitioningPolicy();
        super.buildPolicy((PartitioningPolicy)policy);
        for (RangePartitionMetadata partition : this.getPartitions()) {
            policy.addPartition(new RangePartition(partition.getConnectionPool(), this.getPartitionValueType().getName(), partition.getStartValue(), partition.getEndValue()));
        }
        return policy;
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof RangePartitioningMetadata) {
            RangePartitioningMetadata policy = (RangePartitioningMetadata)objectToCompare;
            return this.valuesMatch(this.partitions, policy.getPartitions());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.partitions != null ? this.partitions.hashCode() : 0);
        return result;
    }

    public List<RangePartitionMetadata> getPartitions() {
        return this.partitions;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.partitions, accessibleObject);
    }

    public void setPartitions(List<RangePartitionMetadata> partitions) {
        this.partitions = partitions;
    }
}

