/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.serialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.arrow.vector.table.ArrowTable;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;

public class KafkaMetricsDataDeserializer
implements Deserializer<CollectRep.MetricsData> {
    public void configure(Map<String, ?> configs, boolean isKey) {
        super.configure(configs, isKey);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public CollectRep.MetricsData deserialize(String s, byte[] bytes) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            CollectRep.MetricsData metricsData;
            try (ArrowStreamReader reader = new ArrowStreamReader(Channels.newChannel(in), (BufferAllocator)new RootAllocator());){
                VectorSchemaRoot root = reader.getVectorSchemaRoot();
                reader.loadNextBatch();
                metricsData = new CollectRep.MetricsData(new ArrowTable(root));
            }
            return metricsData;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to deserialize Arrow table", e);
        }
    }

    public CollectRep.MetricsData deserialize(String topic, Headers headers, byte[] data) {
        return (CollectRep.MetricsData)super.deserialize(topic, headers, data);
    }

    public void close() {
        super.close();
    }
}

